/*
*************************************************************
* File: LCD_test.c
* Description: This file contains the main test program 
*              in ANSI-C, of Character LCD Driver for 
*              the Z8 Encore! microcontroller
*
* Copyright 2004 ZiLOG Inc. ALL RIGHTS RESERVED.
*
* The source code in this file was written by an
* authorized ZiLOG employee or a licensed consultant.
* The source code has been verified to the fullest
* extent possible.
*
* Permission to use this code is granted on a royalty-free
* basis. However users are cautioned to authenticate the
* code contained herein.
*
* ZiLOG DOES NOT GUARANTEE THE VERACITY OF THE SOFTWARE.
************************************************************* */
/*
******************************************************************************
**  Includes
******************************************************************************
*/
#include "LCD_API.h"	/* Header file */
#include "defchar.h"	/* Definitions of character symbols */


/*
******************************************************************************
**  Global Declarations
******************************************************************************
*/
unsigned char text_1[] = "Welcome to eZ8, the revolutionary Flash Microcontroller from ZiLOG with rich set of on-chip peripherals. The Z8 Encore! series can be used for many different applications, like consumer";
unsigned char text_2[] = " appliances, industrial controls, automotive, communications, instrumentation etc.";

/*
******************************************************************************
**
**  Routine:
**      main
**
**  Parameters:
**      void
**
**  Return:
**      void
**
**  Purpose:
**      This function is the base routine for testing LCD APIs
**
**  History:
**      Date            Action
**      ----------      ------------------------------------------------------
**      2002-11-07      Created Version 1.0
**
******************************************************************************
*/

void main(void)
{
	unsigned char new_count;
	LCD_gpio_set();					// Set IO pins appropriately
	init_timer0();					// Initialise Timer0
	EI();							// Enable all Interrupts

	delayms(15);					// Provide customary 15ms power-on delay
	LCD_init();						// Init display
	LCD_blink_off();				// Put-off character blinking

	LCD_setposition(0,5);			// Locate cursor
	LCD_printc('Z');				// Print a character
	LCD_printc('i');
	LCD_printc('L');
	LCD_printc('O');
	LCD_printc('G');

	LCD_setposition(1,0);			// Relocate cursor
	LCD_prints("   Z8 Encore!   ");	// String is centralized on 16x2 LCD only
	delayms(3000);					// Delay 3 seconds

	LCD_clear();					// Clear screen
	LCD_setposition(0,0);			// Relocate cursor
	LCD_prints("LCD demo on eZ8");	// Print a string
	delayms(3000);					// Delay 3 seconds

	LCD_clear();
	LCD_setposition(0,0);
	LCD_prints("New Characters:");

	LCD_copymap(char_map);
	LCD_setposition(1,0);
	new_count = 0 ;
	while (new_count < 8)
		LCD_printc_user(new_count++);
	delayms(3000);					// Delay 3 seconds

	LCD_clear();
	LCD_setposition(0,0);
	LCD_fillchar(0x4D,10);			// Print 'M' 10 times
	delayms(3000);
	LCD_setposition(0,7);
	LCD_backspace();				// Backspace
	LCD_printc('m');				// and print another character
	delayms(3000);					// Delay 3 seconds
	LCD_backspace();
	LCD_printc('e');				// Replace with another character
	delayms(3000);					// Delay 3 seconds

	LCD_insert();
	delayms(3000);

	while(1)
	{
		LCD_scroll(text_1);			// Scroll the long lines of text
		LCD_scroll(text_2);
	}
}	/* main */

