/*
*************************************************************
* File: LCD_API.h
* Description: This file contains the function declarations 
*              used in main.
*
* Copyright 2004 ZiLOG Inc. ALL RIGHTS RESERVED.
*
* The source code in this file was written by an
* authorized ZiLOG employee or a licensed consultant.
* The source code has been verified to the fullest
* extent possible.
*
* Permission to use this code is granted on a royalty-free
* basis. However users are cautioned to authenticate the
* code contained herein.
*
* ZiLOG DOES NOT GUARANTEE THE VERACITY OF THE SOFTWARE.
************************************************************* */
/*
******************************************************************************
**  Definitions & Includes
******************************************************************************
*/
//#include "custom.h"			// Header file for Z8F6403 device (pin access)
#include <eZ8.h>			// Header file for Z8 series (port access)

// Type of LCD
#define LCD_16x2			// Choose either 'LCD_16x2' or 'LCD_40x2'

// Parameters of LCD and Pin connections
#ifdef	LCD_16x2
#define rows				2				// Number of lines in LCD
#define columns				16				// Number of characters in a line
#define start_address_0		0x00			// Start address of first line
#define start_address_1		0x40			// Start address of second line (if any)
#define LCD_RW_port			PE
#define	LCD_RW_pin			P1
#define LCD_E_port			PE
#define	LCD_E_pin			P2
#define LCD_RS_port			PE
#define	LCD_RS_pin			P3
#define LCD_D4_port			PE
#define	LCD_D4_pin			P4
#define LCD_D5_port			PE
#define	LCD_D5_pin			P5
#define LCD_D6_port			PE
#define	LCD_D6_pin			P6
#define LCD_D7_port			PE
#define	LCD_D7_pin			P7
#endif

#ifdef	LCD_40x2
#define rows				2				// Number of lines in LCD
#define columns				40				// Number of characters in a line
#define start_address_0		0x00			// Start address of first line
#define start_address_1		0x40			// Start address of second line
#define LCD_RW_port			PA
#define	LCD_RW_pin			P1
#define LCD_E_port			PB
#define	LCD_E_pin			P2
#define LCD_RS_port			PC
#define	LCD_RS_pin			P3
#define LCD_D4_port			PD
#define	LCD_D4_pin			P4
#define LCD_D5_port			PE
#define	LCD_D5_pin			P0
#define LCD_D6_port			PF
#define	LCD_D6_pin			P6
#define LCD_D7_port			PG
#define	LCD_D7_pin			P7
#endif

// Definitions based on above defines
#define LCD_pin_RW		LCD_RW_port.OUT.BIT.LCD_RW_pin	// Read/Write pin's number = PE1
#define LCD_pin_E		LCD_E_port.OUT.BIT.LCD_E_pin	// Enable pin's number = PE2
#define LCD_pin_RS		LCD_RS_port.OUT.BIT.LCD_RS_pin	// Register select pin's number = PE3
#define LCD_pin_D4		LCD_D4_port.OUT.BIT.LCD_D4_pin	// Data pin PE4
#define LCD_pin_D5		LCD_D5_port.OUT.BIT.LCD_D5_pin	// Data pin PE5
#define LCD_pin_D6		LCD_D6_port.OUT.BIT.LCD_D6_pin	// Data pin PE6
#define LCD_pin_D7		LCD_D7_port.OUT.BIT.LCD_D7_pin	// Data pin PE7
#define	end_address_0	(start_address_0 + columns) // End address of 1st line
#if (rows > 1)
#define	end_address_1	(start_address_1 + columns) // End address of 2nd line
#endif
#if (rows > 2)
#define	end_address_2	(start_address_2 + columns) // End address of 3rd line
#endif
#if (rows > 3)
#define	end_address_3	(start_address_3 + columns) // End address of 4th line
#endif
#define	NULL		'\0'
#define DATA_DIR	0x01
#define ALT_FUN		0x02
#define OUT_CTL		0x03

/*
******************************************************************************
**  Prototype Declarations
******************************************************************************
*/
	void LCD_gpio_set (void);
	void LCD_init (void);
	void LCD_on (void);
	void LCD_off (void);
	void LCD_printc (unsigned char character);
	void LCD_prints (unsigned char *string);
	void LCD_fillchar (unsigned char ascii_char, unsigned char repeat);
	unsigned char LCD_readchar (void);
	void LCD_clear (void);
	void LCD_home (void);
	void LCD_backspace (void);
	void LCD_insert (void);
	void LCD_blink (void);
	void LCD_blink_off (void);
	unsigned char LCD_curpos (void);
	void LCD_setposition (unsigned char row_number, unsigned char column_number);
	void LCD_scroll (unsigned char *long_text);
	void LCD_command (unsigned char command_word);
	void LCD_writedata (unsigned char data_word);
	void LCD_copymap (unsigned char *bitmap);
	void LCD_set_cgram (unsigned char cgram_address);
	void LCD_set_ddram (unsigned char ddram_address);
	void delay (void);
	void isr_timer0(void);
	void init_timer0(void);
	void delayms (unsigned int milliseconds);
	unsigned char LCD_checkbusy (void);
	void LCD_printc_user (unsigned char number);

/*
******************************************************************************
**  End of File
******************************************************************************
*/
