'###################################################
'Schrittmotoransteuerung mit RN-Control und
'Ansteuerungsboard RN-SCHRITTMOTOR ber I2C
'rncontrol_schrittmotor_i2c_1.bas
'
'
'Aufgabe:
' Dieses Testprogramm beschreibt die Motorboard I2C-Funktionen
' und legt einige der Befehle auf die 5 Tasten

' Den verschiedenen Tasten sind bestimmte Funktionen zugeordnet
' Taste 1: Motor endlos drehen (schaltet den Motor automatisch ein)
' Taste 2: Richtungswechsel
' Taste 3: ndert die Geschwindigkeit des linken Motors mit jedem Tastendruck
' Taste 4: Fragt der bereits ausgefhrten Motorschritte des linken Motors vom Board ab und
'          berechnet daraus Umdrehungen und Fahrtstrecke
'          Daten werden ber RS232 angezeigt
''Taste 5: Schaltet den linken Motor wieder aus
'
'Autor: Frank
'Weitere Beispiele und Beschreibung der Hardware
'in der Anleitung zu RN-Schrittmotor
'Anleitung findet man unter http://www.mikrocontroller-elektronik.de/
'Weitere Beispiele sind gerne willkommen!
'##############################################################

$programmer = 12                                            'MCS USB  (Zeile weglassen wenn anderer Programmer)


'  -------------- RN-Control bliche _____________________
Declare Function Tastenabfrage() As Byte

$regfile = "m32def.dat"
$framesize = 32
$swstack = 32
$hwstack = 64

$crystal = 16000000                                         'Quarzfrequenz
$baud = 9600
Config Scl = Portc.0                                        'Ports fuer IIC-Bus
Config Sda = Portc.1

Config Adc = Single , Prescaler = Auto                      'Fr Tastenabfrage und Spannungsmessung
Config Pina.7 = Input                                       'Fr Tastenabfrage
Porta.7 = 1                                                 'Pullup Widerstand ein
Dim Taste As Byte
Dim Ton As Integer

I2cinit
Start Adc
Sound Portd.7 , 400 , 450                                   'BEEP
Sound Portd.7 , 400 , 250                                   'BEEP
Sound Portd.7 , 400 , 450                                   'BEEP
Print
Print "**** RN-CONTROL  V1.4 *****"
Print "Demoprogramm um Zusatzboard RN-Schrittmotor zu testen/demonstrieren"
Print
'  -------------- Ende RN-Control bliche _____________________



'Befehle im Schrittmotorbetrieb
'Ein RN-Schrittmotor Befehl besteht immer aus 7 Bytes, auch wenn einige Befehle
'weniger Parameter bentigen. Wenn weniger Bytes erforderlich sind, werden die unntigen
'Bytes mit beliebigen Wert gefllt und ignoriert. .Die konstante Zahl erleichtert und
'beschleunigt die Interpretation und Verarbeitung!

'Befehlssyntax:
'Befehl, Motor , Par1, Par2, Par3, Par4, crc

Const Befehl_ausschalten = 51                               'Motor ausschalten
Const Befehl_drehrichtung = 52                              'Drehrichtung festlegen
Const Befehl_geschwindigkeit = 53                           'Geschwindigkeit (wahlweise mit Rampe)
Const Befehl_endlosdrehung = 54                             'Motoren endlos bis zu einem Stoppbefehl drehen
Const Befehl_schrittzahlabrufen = 102                       'Aktuell bewegte Schrittzahl abrufen (Long Wert)
Const Befehl_versionstatus = 255                            'Version & Copyright per RS232 ausgeben

Const Motor_1 = 1
Const Motor_2 = 2


Const I2crnmotorslaveadr = &H58                             'I2C SlaveAdresse von RN-Schrittmotor Erweiterung
Const I2crnmotorsreadlaveadr = &H59                         'I2C SlaveAdresse von RN-Schrittmotor Erweiterung
'Achtung, wenn das Motor-Board berhaupt nicht reagiert, dann knnte dieses eine andere Slave
'Adresse besitzen. Im Zweifel schlieen Sie das Motorboard an die RS232 vom PC an und
'drcken Sie die RESET-Taste am Motorboard.Dann wird die Slave ID ber ein
'Terminalprogramm angezeigt werden (9600 Baud).

Dim I2cdaten(7) As Byte                                     'Array um Befehlsfolge auszunehmen
Dim Lowbyte As Byte
Dim Highbyte As Byte
Dim Richtung As Bit


Dim Schritte As Long
Dim Temp As Byte
Dim Ltemp As Long
Dim Umdrehungen As Single
Dim Fahrstrecke As Word

Dim Geschwindigkeit As Byte




Richtung = 0
Geschwindigkeit = 250


Do
   Taste = Tastenabfrage()
   If Taste <> 0 Then

      Select Case Taste

         Case 1                                             'Motor endlos drehen
            I2cdaten(1) = Befehl_endlosdrehung              'Befehlscode
            I2cdaten(2) = Motor_1                           '1 Parameter
            I2csend I2crnmotorslaveadr , I2cdaten(1) , 7    'Befehl wird gesendet (es sollten immer 7 Bytes gesendet werden, auch wenn weniger Parameter notwendig sind)

         Case 2                                             'Motor endlos drehen
            Toggle Richtung
            I2cdaten(1) = Befehl_drehrichtung               'Befehlscode
            I2cdaten(2) = Motor_1                           '1 Parameter
            I2cdaten(3) = Richtung                          '2 Parameter
            I2csend I2crnmotorslaveadr , I2cdaten(1) , 7    'Befehl wird gesendet (es sollten immer 7 Bytes gesendet werden, auch wenn weniger Parameter notwendig sind)
                     'Richtung umkehren


         Case 3                                             'Geschwindigkeit ndern
            If Geschwindigkeit > 40 Then
              Geschwindigkeit = Geschwindigkeit - 20
            Else
              Geschwindigkeit = Geschwindigkeit - 1
            End If
            Print "Geschwindigkeitsstufe: " ; Geschwindigkeit
            I2cdaten(1) = Befehl_geschwindigkeit            'Befehlscode
            I2cdaten(2) = Motor_1                           '1 Parameter
            I2cdaten(3) = Geschwindigkeit                   '2 Parameter
            I2cdaten(4) = 0                                 '3 Parameter (wie schnell Geschwindigkeit gendert werden soll)
            I2csend I2crnmotorslaveadr , I2cdaten(1) , 7    'Befehl wird gesendet (es sollten immer 7 Bytes gesendet werden, auch wenn weniger Parameter notwendig sind)



         Case 4                                             'Motor fr Datenabruf anwhlen

             I2cdaten(1) = Befehl_schrittzahlabrufen        'Befehlscode
             I2cdaten(2) = Motor_1                          '1 Parameter
             I2csend I2crnmotorslaveadr , I2cdaten(1) , 7   'Befehl wird gesendet (es sollten immer 7 Bytes gesendet werden, auch wenn weniger Parameter notwendig sind)

            'Schritte abrufen und Umdrehungen und Fahrtstrecke berechnen und ber RS232 anzeigen
             I2cstart
             I2cwbyte I2crnmotorsreadlaveadr
             I2crbyte Temp , Ack
             Schritte = Temp
             I2crbyte Temp , Ack
             Ltemp = Temp * 256
             Schritte = Schritte + Ltemp
             I2crbyte Temp , Ack
             Ltemp = Temp * 65536
             Schritte = Schritte + Ltemp
             I2crbyte Temp , Nack
             Ltemp = Temp * 16777216
             Schritte = Schritte + Ltemp
             I2cstop
             Print "Schrittanzahl:" ; Schritte
             Umdrehungen = Schritte / 200                   'Wenn Schrittwinkel 1,8 Grad betrgt dann durch 200 teilen
             Print "Umdrehungen: " ; Umdrehungen
            'Umfang des rades mal Umdrehungen ergibt Fahrtstrecke
            'Umfang berechnet sich auch U=3.14 * Druchmesser
            'In dem Beispiel nehmen wir ein 10 cm Rad am Roboter an
             Fahrstrecke = Umdrehungen * 31.4
             Print "Der Roboter ist " ; Fahrstrecke ; " cm gefahren "



          Case 5                                            'Motor ausschalten
            I2cdaten(1) = Befehl_ausschalten                'Befehlscode
            I2cdaten(2) = Motor_1                           '1 Parameter
            I2csend I2crnmotorslaveadr , I2cdaten(1) , 7    'Befehl wird gesendet (es sollten immer 7 Bytes gesendet werden, auch wenn weniger Parameter notwendig sind)



      End Select
      Sound Portd.7 , 400 , 500                             'BEEP
   End If

   Waitms 100
Loop

End




' Diese Unterfunktion fragt die Tastatur am analogen Port ab
' Sollte beim bettigen einer Taste kein Quittungston kommen, dann
' muss die die Tastenabfrage (Select Case Anweisung in Funktion )
' an ihr Board angepat werden. Widerstandstoleranzen sorgen in
' Einzelfllen manchmal dafr das die Werte etwas anders ausfallen
' Am besten dann den WS wert mit Print fr jede Taste ausgeben lassen

Function Tastenabfrage() As Byte
Local Ws As Word

   Tastenabfrage = 0
   Ton = 600
   Ws = Getadc(7)
'   Print "ws= " ; Ws
   If Ws < 1010 Then
      Select Case Ws
         Case 370 To 450
            Tastenabfrage = 1
            Ton = 550
         Case 300 To 369
            Tastenabfrage = 2
            Ton = 500
         Case 230 To 299
            Tastenabfrage = 3
            Ton = 450
         Case 150 To 229
            Tastenabfrage = 4
            Ton = 400
         Case 80 To 149
            Tastenabfrage = 5
            Ton = 350
      End Select
      Sound Portd.7 , 400 , Ton                             'BEEP
   End If

End Function

