'###################################################
'Schrittmotoransteuerung mit RN-Control und
'Ansteuerungsboard RN-SCHRITTMOTOR ber RS232
'RN-Schrittmotor ist das Nachfolgeboard von RN-Motor
'rncontrol_schrittmotor_rs2321.bas
'
'
'Aufgabe:
' Dieses Testprogramm beschreibt die Motorboard RS232-Funktionen
' und legt einige der Befehle auf die 5 Tasten

' Den verschiedenen Tasten sind bestimmte Funktionen zugeordnet
' Taste 1: Motor endlos drehen (schaltet den Motor automatisch ein)
' Taste 2: Richtungswechsel
' Taste 3: Fragt der bereits ausgefhrten Motorschritte des linken Motors vom Board ab und
'          berechnet daraus Umdrehungen und Fahrtstrecke
'          Daten werden ber RS232 angezeigt
' Taste 4: ndert die Geschwindigkeit des linken Motors mit jedem Tastendruck
''Taste 5: Schaltet den linken Motor wieder aus
'
'Autor: Frank
'Weitere Beispiele und Beschreibung der Hardware
'in der Anleitung zu RN-Schrittmotor
'Anleitung findet man unter http://www.mikrocontroller-elektronik.de/
'Weitere Beispiele sind dort gerne willkommen!
'##############################################################

$programmer = 12                                            'MCS USB  (Zeile weglassen wenn anderer Programmer)


'  -------------- RN-Control bliche _____________________
Declare Function Tastenabfrage() As Byte

$regfile = "m32def.dat"
$framesize = 64
$swstack = 64
$hwstack = 64

$crystal = 16000000                                         'Quarzfrequenz
$baud = 9600
Config Scl = Portc.0                                        'Ports fuer IIC-Bus
Config Sda = Portc.1

Config Adc = Single , Prescaler = Auto                      'Fr Tastenabfrage und Spannungsmessung
Config Pina.7 = Input                                       'Fr Tastenabfrage
Porta.7 = 1                                                 'Pullup Widerstand ein
Dim Taste As Byte
Dim Ton As Integer

I2cinit
Start Adc
Sound Portd.7 , 400 , 450                                   'BEEP
Sound Portd.7 , 400 , 250                                   'BEEP
Sound Portd.7 , 400 , 450                                   'BEEP
Print
Print "**** RN-CONTROL  V1.4 *****"
Print "Demoprogramm um Zusatzboard RN-Schrittmotor zu testen/demonstrieren"
Print
'  -------------- Ende RN-Control bliche _____________________


Declare Sub Sendebytearray()


'Befehle im Schrittmotorbetrieb
'Ein RN-Schrittmotor Befehl besteht immer aus 7 Bytes, auch wenn einige Befehle
'weniger Parameter bentigen. Wenn weniger Bytes erforderlich sind, werden die unntigen
'Bytes mit beliebigen Wert gefllt und ignoriert. .Die konstante Zahl erleichtert und
'beschleunigt die Interpretation und Verarbeitung!

'Befehlssyntax:
'Befehl, Motor , Par1, Par2, Par3, Par4, crc

Const Befehl_ausschalten = 51                               'Motor ausschalten
Const Befehl_drehrichtung = 52                              'Drehrichtung festlegen
Const Befehl_geschwindigkeit = 53                           'Geschwindigkeit (wahlweise mit Rampe)
Const Befehl_endlosdrehung = 54                             'Motoren endlos bis zu einem Stoppbefehl drehen
Const Befehl_schrittzahlabrufen = 102                       'Aktuell bewegte Schrittzahl abrufen (Long Wert)
Const Befehl_versionstatus = 255                            'Version & Copyright per RS232 ausgeben

Const Motor_1 = 1
Const Motor_2 = 2



Dim Rs232daten(7) As Byte                                   'Array um Befehlsfolge auszunehmen
Dim Lowbyte As Byte
Dim Highbyte As Byte
Dim Richtung As Bit


Dim Schritte As Long
Dim Temp As Byte
Dim Ltemp As Long
Dim Umdrehungen As Single
Dim Fahrstrecke As Word

Dim Geschwindigkeit As Byte


'------------------------------------------------------------
' Dieser Abschnitt ist nur notwendig wenn RN-KeyLCD als
' LCD Ausgabe genutzt werdne soll
Const Rnkeylcd_slaveid_write = &H40                         'I2C SlaveAdresse
Const Rnkeylcd_slaveid_read = &H41
Dim Empfang(5) As Byte
Dim Stemp As String * 100
I2cinit
'-------------------------------------------------------------


Richtung = 0
Geschwindigkeit = 250


Do
   Taste = Tastenabfrage()
   If Taste <> 0 Then

      Select Case Taste

         Case 1                                             'Motor endlos drehen
            Rs232daten(1) = Befehl_endlosdrehung            'Befehlscode
            Rs232daten(2) = Motor_1                         '1 Parameter
            Sendebytearray


         Case 2                                             'Motor endlos drehen
            Toggle Richtung
            Rs232daten(1) = Befehl_drehrichtung             'Befehlscode
            Rs232daten(2) = Motor_1                         '1 Parameter
            Rs232daten(3) = Richtung                        '2 Parameter
            Sendebytearray



         Case 3                                             'Geschwindigkeit ndern
            If Geschwindigkeit > 40 Then
              Geschwindigkeit = Geschwindigkeit - 20
            Else
              Geschwindigkeit = Geschwindigkeit - 1
            End If
            Rs232daten(1) = Befehl_geschwindigkeit          'Befehlscode
            Rs232daten(2) = Motor_1                         '1 Parameter
            Rs232daten(3) = Geschwindigkeit                 '2 Parameter
            Rs232daten(4) = 0                               '3 Parameter (wie schnell Geschwindigkeit gendert werden soll)
            Sendebytearray



         Case 4                                             'Motor fr Datenabruf anwhlen
             Do : Loop Until Inkey() = 0                    'Diese Zeile leert Buffer

             Rs232daten(1) = Befehl_schrittzahlabrufen      'Befehlscode
             Rs232daten(2) = Motor_1                        '1 Parameter
             Sendebytearray

             Inputbin Empfang(1) , 5
             Schritte = Empfang(1)
             Ltemp = Empfang(2) * 256
             Schritte = Schritte + Ltemp
             Ltemp = Empfang(3) * 65536
             Schritte = Schritte + Ltemp
             Ltemp = Empfang(4) * 16777216
             Schritte = Schritte + Ltemp

             Stemp = Chr(12) : I2csend Rnkeylcd_slaveid_write , Stemp , 1       'LCD Lschen
             Stemp = Str(schritte) : I2csend Rnkeylcd_slaveid_write , Stemp , 10       'Schritte auf LCD ausgeben




          Case 5                                            'Motor ausschalten
            Rs232daten(1) = Befehl_ausschalten              'Befehlscode
            Rs232daten(2) = Motor_1                         '1 Parameter
            Sendebytearray



      End Select
      Sound Portd.7 , 400 , 500                             'BEEP
   End If

   Waitms 100
Loop

End




' Diese Unterfunktion fragt die Tastatur am analogen Port ab
' Sollte beim bettigen einer Taste kein Quittungston kommen, dann
' muss die die Tastenabfrage (Select Case Anweisung in Funktion )
' an ihr Board angepat werden. Widerstandstoleranzen sorgen in
' Einzelfllen manchmal dafr das die Werte etwas anders ausfallen
' Am besten dann den WS wert mit Print fr jede Taste ausgeben lassen

Function Tastenabfrage() As Byte
Local Ws As Word

   Tastenabfrage = 0
   Ton = 600
   Ws = Getadc(7)
'   Print "ws= " ; Ws
   If Ws < 1010 Then
      Select Case Ws
         Case 400 To 455
            Tastenabfrage = 1
            Ton = 550
         Case 335 To 380
            Tastenabfrage = 2
            Ton = 500
         Case 250 To 305
            Tastenabfrage = 3
            Ton = 450
         Case 180 To 220
            Tastenabfrage = 4
            Ton = 400
         Case 100 To 130
            Tastenabfrage = 5
            Ton = 350
      End Select
      Sound Portd.7 , 400 , Ton                             'BEEP
   End If

End Function


'Hilfsfunktion um Befehle zu senden
Sub Sendebytearray()
Local I As Byte
  Print "!#";
  For I = 1 To 7
    Print Chr(rs232daten(i));
  Next I
End Sub
