
/* Dieses PACKAGE RN_Schrittmotor wurde von C.Malonga erstellt

 ->	natrlich fr alle, die mit der Steuerung RN-Schrittmotor
 	von www.Robotikhardware.de Projekte mit Java an RS232 realisieren wollen :)
 	Viel Spass dabei!
*/

	package RN_Schrittmotor;

	import java.io.*;
	import java.awt.*;

	import javax.swing.*;

	import java.util.*;

	import java.net.*;
	import javax.*;

	//  fr die Nutzung des nachfolgenden Packages mu die Instalationsanweisung
	//  in der README.PDF befolgt werden!

	import javax.comm.*;



public class Schrittmotorsteuerung

{
	// KOMPONENTEN fr die PORTANSTEUERUNG

	public static CommPortIdentifier serialPortId;
	public static Enumeration enumComm;
	public static SerialPort serialPort;

	public static OutputStream outputStream;
	public static InputStream inputStream;

	public static Boolean serialPortGeoeffnet = false;

	public static int baudrate = 9600;
	public static int dataBits = SerialPort.DATABITS_8;
	public static int stopBits = SerialPort.STOPBITS_1;
	public static int parity = SerialPort.PARITY_NONE;

    public static String portName_SerialPort_1 = "COM1";		//  es knnen natrlich auch andere Portnamen verwendet werden

	public static byte[] data = new byte[25];
	public static byte[] byte_konvertierung = new byte[2];



	// KOMPONENTEN FR DEN RN_STEUERUNGSBEFEHL

    public static byte Befehl_Parameter_1_Kennung 		= 33;	// default auf ! -> 33
    public static byte Befehl_Parameter_2_Kennung 		= 35;	// default auf # -> 35

    public static byte Befehl_Parameter_3_Befehlscode 	=  0;	// klassifiziert den Befehl (10 bis 255)

    public static byte Befehl_Parameter_4_Motor 		=  0;	// 1 fr Motor A, 2 fr B und 3 fr A und B
    public static byte Befehl_Parameter_5_Parameter 	=  0;	// je nach Befehl
    public static byte Befehl_Parameter_6_Parameter 	=  0;	// je nach Befehl
    public static byte Befehl_Parameter_7_Parameter 	=  0;	// je nach Befehl
    public static byte Befehl_Parameter_8_Parameter 	=  0;	// je nach Befehl
    public static byte Befehl_Parameter_9_CRC 			=  0;	// 0 fr CRC aus, 1 fr CRC an

	public static int letzter_gegebener_Befehl = 0;				// ist wichtig, fr Befehlsberblick



	// KOMPONENTEN FR DIE RCKMELDUNG DES BOARDS

	public static String aktuelle_Rueckmeldung = "";
	public static String aktuelle_Rueckmeldung_Zwischenspeicher = "";

	public static byte[] aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray = new byte[50];

	public static int Methodenaufrufzaehler = 0;



	/*

	CODES FR DIE STEUERUNGSBEFEHLE (siehe auch das PDF von Robotikhardware.de)

	10 Motorstrom festlegen
	[Parameter 5: LowByte - Strom in mA | Parameter 6: HighByte - Strom in mA | Parameter 7: Gltigkeit - 0 fr Flash, 1 fr EEPROM]

	11 Anlauf Motorstrom festlegen (Motorboard nutzt eventuell kurzzeitig einen hheren	Anlaufstrom)
	[Parameter 5: LowByte - Strom in mA | Parameter 6: HighByte - Strom in mA | Parameter 7: Gltigkeit - 0 fr Flash, 1 fr EEPROM]

	12 Haltestrom fr Stillstand festlegen
	[Parameter 5: LowByte - Strom in mA | Parameter 6: HighByte - Strom in mA | Parameter 7: Gltigkeit - 0 fr Flash, 1 fr EEPROM]

	13 Vollschritt oder Halbschrittmodi festlegen (gilt fr beide Motoren)
	[Parameter 4: immer 3 | Parameter 5: Modus - 0 Vollschritt, 1 Halbschritt | Parameter 6: Gltigkeit - 0 fr Flash, 1 fr EEPROM]

	14 Schrittzhler auf Null setzen
	[Parameter 5 bis 8: immer 0]

	50 Motor einschalten / Motorstellung halten (Haltestrom aktiv)
	[Parameter 5 bis 8: immer 0]

	51 Motor komplett ausschalten
	[Parameter 5 bis 8: immer 0]

	52 Drehrichtung festlegen
	[Parameter 5: Drehsinn - 0 links, 1 rechts]

	53 Geschwindigkeit und Beschleunigung festlegen
	[Parameter 5: Zielgeschwindigkeit - 0 (langsam) bis 255 (schnell) | Parameter 6: Beschleunigung - 0 (schlagartig), 255 (langsam)]

	54 Motoren endlos bis zu einem Stopbefehl drehen
	[Parameter 5 bis 8: immer 0]

	55 Motoren bestimte Schrittzahl drehen
	[Parameter 5: Schrittanzahl - Anzahl Schritte]

	101 Motorstatus abrufen (ob er steht, noch dreht)
	[Parameter 5 bis 8: immer 0] auf Rckantwort warten

	102 Aktuell gedrehte Schrittzahl abrufen (daraus lt sich Wegstrecke errechnen)
	[Parameter 5 bis 8: immer 0] auf Rckantwort warten

	203 Board in Urzustand zurcksetzen (Eeprom wieder in Anfangszustand bringen)
	[Parameter 4: Sicherheitsbefehl - 203]

	254 Eeprom Werte abrufen
	[Parameter 4: Anzahl EEPROM-Bytes - 1 bis 50]

	255 Firmware-Version,Copyright, Betriebsmodi und Slave-ID werden per RS232 ausgegeben
	[Parameter 5 bis 8: immer 0] auf Rckantwort warten


	* NACHSTEHENDE CODES WERDEN HIER NICHT BEHANDELT *

	103 Letzte Befehlsbesttigung fr I2C abruf selektieren
	104 Abfragen welche Endschalter geschlossen sind
	201 CRC-Prfsummenmode aktivieren bzw. deaktivieren
	202 I2C Slave ID festlegen
	200 Schrittmotormodi einstellen (Intelligente RS232/I2C oder passive Taktsteuerung)




	// BIBLIOTHEK DER METHODEN

	public boolean 	SerialPort_open()				ffnet den seriellen Port
	public void 	SerialPort_close()				schliet den seriellen Port
	public void 	SerialPort_update()				aktualisiert die Portliste
	public void 	SerialPort_send()				Sendet die BefehlBytes zum seriellen Port
	public void 	SerialPort_dataOnline()			reagiert auf Rckantworten (ist immer eingeschaltet durch den SerialPortEventListener)

	private int 	ByteToInt(byte b0, byte b1)		Konvertierung der ausgelesenen Eeprom-Rckgabe-Bytes von 'byte' nach 'int'
	private byte[] 	CharToByteArray(char c)			Konvertierungsmethode, um int ber char nach byte zu konvertieren. Wichtig fr das senden von Stromwerten.


	//	-> VOREINSTELLUNGEN

	public void 	Motorstrom_festlegen(int MotorCode, int Stromstaerke, int EEPROM)
	public void 	Anlaufstrom_festlegen(int MotorCode, int Stromstaerke, int EEPROM)
	public void 	Haltestrom_festlegen(int MotorCode, int Stromstaerke, int EEPROM)
	public void 	Schrittmodus_festlegen(int Schrittmodus, int EEPROM)
	public void 	Drehsinn_festlegen(int MotorCode, String Drehsinn)
	public void 	Geschwindigkeit_festlegen(int MotorCode, int Zielgschwindigkeit, int Beschleunigung)


	//	-> STEUERUNG

	public void 	Haltestrom_einschalten(int MotorCode)
	public void 	Motor_ausschalten(int MotorCode)
	public void 	Endlossdrehung_einschalten(int MotorCode)
	public void 	Schrittanzahldrehung_einschalten(int MotorCode, int Schrittanzahl)


	//	-> STATUSABFRAGE

	public String 	getStepperStatus(int MotorCode)		zeigt an, ob der Motor sich endloss oder bestimmt dreht und ob er steht oder ausgeschaltet ist
	public long 	getStepCount(int MotorCode)			liefert die gefahrenen Schritte des jeweiligen Motors zurck
	public int		getLastOrder()						zeigt den letzten gesendeten Befehlscode an


	//	-> RESET

	public void 	setBoardReset(Boolean wirklich_reset)
	public void 	Schrittzaehler_nullsetzen(int MotorCode)


	//	-> BERSICHT BER DIE PARAMETER

	int MotorCode = 1 fr Motor A, 2 fr B und 3 fr Motor A und B
	int EEPROM = 0 fr nderungsspeicherung im Flashspeicher, 1 fr dauerhafte Speicherung
	int Schrittanzahl = von 0 bis unglaublich viele Schritte

	String Drehsin = "links" oder "rechts"

	int Beschleunigung = von 0 (schlagartig) bis 255 (langsam)
	int Zielgeschwindigkeit = von 0 (schnell) bis 255 (langsam)

		Geschwindigkeit der Stufen:

		0= 1000 Schritte pro Sekunde
		1=  500 Schritte pro Sekunde
		2=  333 Schritte pro Sekunde
		3=  250 Schritte pro Sekunde
		4=  200 Schritte pro Sekunde
		5=  167 Schritte pro Sekunde
		6=  142 Schritte pro Sekunde
		7=  125 Schritte pro Sekunde
		8=  111 Schritte pro Sekunde

		[usw]

		255=  4 Schritte pro Sekunde

		Zielgeschwindigkeitsstufe: G = 1000 / (Geschw. +1);

	boolean wirklich_reset = true oder false

	*/



	public static boolean SerialPort_open()

	{
		Boolean foundPort = false;

		if (serialPortGeoeffnet != false)

		{
			System.out.println("Serialport bereits geoeffnet");
			return false;
		}

		System.out.println("Oeffne Serialport");
		enumComm = CommPortIdentifier.getPortIdentifiers();

		while(enumComm.hasMoreElements())

		{
			serialPortId = (CommPortIdentifier) enumComm.nextElement();

			if (portName_SerialPort_1.contentEquals(serialPortId.getName()))

			{
				foundPort = true;
				break;
			}
		}


		if (foundPort != true)

		{
			System.out.println("Serialport nicht gefunden: " + portName_SerialPort_1);
			return false;
		}


		try {
				serialPort = (SerialPort) serialPortId.open("Oeffnen und Senden", 500);
			} catch (PortInUseException e) {System.out.println("Port belegt");}

		try {
				outputStream = serialPort.getOutputStream();
			} catch (IOException e) {System.out.println("Keinen Zugriff auf OutputStream");}

		try {
				inputStream = serialPort.getInputStream();
			} catch (IOException e) {System.out.println("Keinen Zugriff auf InputStream");}

		try {
				serialPort.addEventListener(new serialPortEventListener());
			} catch (TooManyListenersException e) {System.out.println("TooManyListenersException fr Serialport");}


		serialPort.notifyOnDataAvailable(true);


		try {
				serialPort.setSerialPortParams(baudrate, dataBits, stopBits, parity);
			} catch(UnsupportedCommOperationException e) {System.out.println("Konnte Schnittstellen-Paramter nicht setzen");}


		serialPortGeoeffnet = true;
		return true;

	} // Ende: method SerialPort_open()



	public static void SerialPort_close()

	{
		if (serialPortGeoeffnet == true)

		{
			System.out.println("Schliee Serialport");
			serialPort.close();
			serialPortGeoeffnet = false;
		}

		else

		{
			System.out.println("Serialport bereits geschlossen");
		}

	} // Ende: method SerialPort_close()



	public static void SerialPort_update()

	{
		System.out.println("Akutalisiere Serialport-Liste");

		if (serialPortGeoeffnet != false)

		{
			System.out.println("Serialport ist geoeffnet");
			return;
		}

		enumComm = CommPortIdentifier.getPortIdentifiers();

		while(enumComm.hasMoreElements())

		{
			serialPortId = (CommPortIdentifier) enumComm.nextElement();

			if (serialPortId.getPortType() == CommPortIdentifier.PORT_SERIAL)

			{
				System.out.println("Found:" + serialPortId.getName());
			}
		}

	} // Ende: method SerialPort_update()



	public static void SerialPort_send()

	{
		System.out.println("Sende: Steuerungsbefehl(" + (0x000000FF & (int)Befehl_Parameter_3_Befehlscode) + ")");


		// warte fr 200ms damit der Befehl richtig bermittelt wird und keine berschneidungen stattfinden knnen

		try {
				Thread.sleep(200);

			} catch (InterruptedException e) {}


		if (serialPortGeoeffnet != true)
			return;

    	 try {
				outputStream.write(Befehl_Parameter_1_Kennung);
				outputStream.write(Befehl_Parameter_2_Kennung);
				outputStream.write(Befehl_Parameter_3_Befehlscode);
				outputStream.write(Befehl_Parameter_4_Motor);
				outputStream.write(Befehl_Parameter_5_Parameter);
				outputStream.write(Befehl_Parameter_6_Parameter);
				outputStream.write(Befehl_Parameter_7_Parameter);
				outputStream.write(Befehl_Parameter_8_Parameter);
				outputStream.write(Befehl_Parameter_9_CRC);

      	} catch (IOException e) {System.err.println("Fehler: Konnte den Befehl nicht uebermitteln!");}

	} // Ende: method SerialPort_send()



	public static void SerialPort_dataOnline()

	{
		try {

			int num;

			while (inputStream.available() > 0)

			{
				num = inputStream.read(data, 0, data.length);

				//System.out.println("Empfange: "+ new String(data, 0, num));


				// RCKMELDUNGEN UND STATUS

				// speichert den aktuell ausgelesenen Byte als String im Zwischenspeicher

				aktuelle_Rueckmeldung_Zwischenspeicher = new String(data, 0, num);


				// speichert den aktuell ausgelesenen Byte im Zwischenspeicher ByteArray wenn die EEPROM-Bytes bentigt werden

				if (letzter_gegebener_Befehl == 254)

				{
					for (int i=0; i<=7; i++)

					{
						aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[i+Methodenaufrufzaehler] = data[i];
					}
				}

				// Ende: RCKMELDUNGEN UND STATUS


				// BEFEHLRCKMELDUNG

				if (new String(data, 0, num).equals("*"))

				{
					System.out.println("Hat alles geklappt! Befehl wurde uebermittelt!");
					//System.out.println(aktuelle_Rueckmeldung);
				}

				// Ende: RCKMELDUNGEN UND STATUS


				// FEHLERMELDUNGEN

				if (new String(data, 0, num).equals("+"))

				{
					System.out.println("Unbekannter Befehl!");
					//System.out.println(aktuelle_Rueckmeldung);
				}

				if (new String(data, 0, num).equals(","))

				{
					System.out.println("CRC-Prfsumme stimmt nicht!");
					//System.out.println(aktuelle_Rueckmeldung);
				}

				// Ende: FEHLERMELDUNGEN


			} // Ende: while-Schleife

		} catch (IOException e) {System.out.println("Fehler beim Lesen empfangener Daten");}


	} // Ende: method SerialPort_dataOnline()



	// die nachstehende Methode, ist zur Konvertierung der ausgelesenen Eeprom-Rckgabe-Bytes von 'byte' nach 'int'

	private static int ByteToInt(byte b0, byte b1)

	{
		int ret = 0;

		if (b0<0)

		{
			ret = (int)(char)(b0+256)*256;
		}

		else

		{
			ret = (int)(char)b0*256;

			if (b1<0)

			{
				ret += b1+256;
			}

			else

			{
				ret += b1;
			}
		}
			return  ret;

	} // Ende: method ByteToInt()



	// die nachstehende Methode, ist zur Konvertierung 'char'  nach 'byte'

   private static byte[] CharToByteArray(char c)

   {
    	byte_konvertierung[0] = (byte)(c & 0xff);
    	byte_konvertierung[1] = (byte)(c >> 8 & 0xff);

    	return byte_konvertierung;

   } // Ende: ChatToByteArray








////////////////////////////////////////////////////////////////////////////////////////////////////////



	public static void Motorstrom_festlegen(int MotorCode, int Stromstaerke, int EEPROM)

	{
		Befehl_Parameter_3_Befehlscode = 10;
		Befehl_Parameter_4_Motor = (byte)MotorCode;

		char c = (char)Stromstaerke;
		CharToByteArray(c);

		Befehl_Parameter_5_Parameter = byte_konvertierung[0];
		Befehl_Parameter_6_Parameter = byte_konvertierung[1];
    	Befehl_Parameter_7_Parameter = (byte)EEPROM;
    	letzter_gegebener_Befehl = 10;

		System.out.println("Steuerungsbefehl(Motorstrom_festlegen)");

		SerialPort_send();
		Befehl_Parameter_nullsetzen();
	}



	public static void Anlaufstrom_festlegen(int MotorCode, int Stromstaerke, int EEPROM)

	{
		Befehl_Parameter_3_Befehlscode = 11;
		Befehl_Parameter_4_Motor = (byte)MotorCode;

		char c = (char)Stromstaerke;
		CharToByteArray(c);

		Befehl_Parameter_5_Parameter = byte_konvertierung[0];
		Befehl_Parameter_6_Parameter = byte_konvertierung[1];
    	Befehl_Parameter_7_Parameter = (byte)EEPROM;
    	letzter_gegebener_Befehl = 11;

		System.out.println("Steuerungsbefehl(Anlaufstrom_festlegen)");

		SerialPort_send();
		Befehl_Parameter_nullsetzen();
	}



	public static void Haltestrom_festlegen(int MotorCode, int Stromstaerke, int EEPROM)

	{
		Befehl_Parameter_3_Befehlscode = 12;
		Befehl_Parameter_4_Motor = (byte)MotorCode;

		char c = (char)Stromstaerke;
		CharToByteArray(c);

		Befehl_Parameter_5_Parameter = byte_konvertierung[0];
		Befehl_Parameter_6_Parameter = byte_konvertierung[1];
    	Befehl_Parameter_7_Parameter = (byte)EEPROM;
		letzter_gegebener_Befehl = 12;

		System.out.println("Steuerungsbefehl(Haltestrom_festlegen)");

		SerialPort_send();
		Befehl_Parameter_nullsetzen();
	}



	public static void Schrittmodus_festlegen(int Schrittmodus, int EEPROM)

	{
		Befehl_Parameter_3_Befehlscode = 13;
		Befehl_Parameter_4_Motor = 3;	// immer beide Motoren
		Befehl_Parameter_5_Parameter = (byte)Schrittmodus;
		Befehl_Parameter_7_Parameter = (byte)EEPROM;
		letzter_gegebener_Befehl = 13;

		System.out.println("Steuerungsbefehl(Schrittmodus_festlegen)");

		SerialPort_send();
		Befehl_Parameter_nullsetzen();
	}



	public static void Schrittzaehler_nullsetzen(int MotorCode)

	{
		Befehl_Parameter_3_Befehlscode = 14;
		Befehl_Parameter_4_Motor = (byte)MotorCode;
		letzter_gegebener_Befehl = 14;

		System.out.println("Steuerungsbefehl(Schrittzaehler_nullsetzen)");

		SerialPort_send();
		Befehl_Parameter_nullsetzen();
	}




	public static void Haltestrom_einschalten(int MotorCode)

	{
		Befehl_Parameter_3_Befehlscode = 50;
		Befehl_Parameter_4_Motor = (byte)MotorCode;
		letzter_gegebener_Befehl = 50;

		System.out.println("Steuerungsbefehl(Haltestrom_einschalten)");

		SerialPort_send();
		Befehl_Parameter_nullsetzen();
	}



	public static void Motor_ausschalten(int MotorCode)

	{
		Befehl_Parameter_3_Befehlscode = 51;
		Befehl_Parameter_4_Motor = (byte)MotorCode;
		letzter_gegebener_Befehl = 51;

		System.out.println("Steuerungsbefehl(Motor_ausschalten)");

		SerialPort_send();
		Befehl_Parameter_nullsetzen();
	}



	public static void Drehsinn_festlegen(int MotorCode, String Drehsinn)

	{
		Befehl_Parameter_3_Befehlscode = 52;
		Befehl_Parameter_4_Motor = (byte)MotorCode;
		letzter_gegebener_Befehl = 52;


		if (Drehsinn.equals("links"))

		{
			Befehl_Parameter_4_Motor = 0;
		}

		if (Drehsinn.equals("rechts"))

		{
			Befehl_Parameter_5_Parameter = 1;
		}

		System.out.println("Steuerungsbefehl(Drehsinn_festlegen)");

		SerialPort_send();
		Befehl_Parameter_nullsetzen();
    }



	public static void Geschwindigkeit_festlegen(int MotorCode, int Zielgschwindigkeit, int Beschleunigung)

	{
		Befehl_Parameter_3_Befehlscode = 53;
		Befehl_Parameter_4_Motor = (byte)MotorCode;
    	Befehl_Parameter_5_Parameter = (byte)Zielgschwindigkeit;
    	Befehl_Parameter_6_Parameter = (byte)Beschleunigung;
    	letzter_gegebener_Befehl = 53;

    	// Zielgeschwindigkeit - 0 (schnell) bis 255 (langsam)
    	// Beschleunigung - 0 (schlagartig), 255 (langsam)

		System.out.println("Steuerungsbefehl(Geschwindigkeit_festlegen)");

		SerialPort_send();
		Befehl_Parameter_nullsetzen();
	}



	public static void Endlossdrehung_einschalten(int MotorCode)

	{
		Befehl_Parameter_3_Befehlscode = 54;
		Befehl_Parameter_4_Motor = (byte)MotorCode;
		letzter_gegebener_Befehl = 54;

		System.out.println("Steuerungsbefehl(Endlossdrehung_einschalten)");

		SerialPort_send();
		Befehl_Parameter_nullsetzen();
	}



	public static void Schrittanzahldrehung_einschalten(int MotorCode, int Schrittanzahl)

	{
		Befehl_Parameter_3_Befehlscode = 55;
		Befehl_Parameter_4_Motor = (byte)MotorCode;

		char c = (char)Schrittanzahl;
		CharToByteArray(c);

		Befehl_Parameter_5_Parameter = byte_konvertierung[0];
		Befehl_Parameter_6_Parameter = byte_konvertierung[1];
    	letzter_gegebener_Befehl = 55;

		System.out.println("Steuerungsbefehl(Schrittanzahldrehung_einschalten)");

		SerialPort_send();
		Befehl_Parameter_nullsetzen();
	}



	public static String getStepperStatus(int MotorCode)

	{
		String StepperStatus = "";

		if (MotorCode >= 3)

		{
			System.out.println("ERROR: MotorStatus fr jeden Motor seperat erfragen!");
		}

		else

		{
			Befehl_Parameter_3_Befehlscode = 101;
			Befehl_Parameter_4_Motor = (byte)MotorCode;
			letzter_gegebener_Befehl = 101;

			System.out.println("Steuerungsbefehl(getStepperStatus)");

			SerialPort_send();
			Befehl_Parameter_nullsetzen();

			// warten, damit das ByteArray "data[]" voll wird!

			try {
					Thread.sleep(500);

				} catch (InterruptedException e) {}



			if (data[0] == 0)

			{
				System.out.println("Motor " + MotorCode + ": ausgeschaltet!");
				StepperStatus = "Motor " + MotorCode + ": ausgeschaltet!";
			}

			if (data[0] == 1)

			{
				System.out.println("Motor " + MotorCode + ": haelt Position!");
				StepperStatus = "Motor " + MotorCode + ": haelt Position!";
			}


			if (data[0] == 2)

			{
				System.out.println("Motor " + MotorCode + ": dreht mit bestimmter Schrittanzahl!");
				StepperStatus = "Motor " + MotorCode + ": dreht mit bestimmter Schrittanzahl!";
			}


			if (data[0] == 3)

			{
				System.out.println("Motor " + MotorCode + ": dreht unendlich!");
				StepperStatus = "Motor " + MotorCode + ": dreht unendlich!";
			}
		}

		return StepperStatus;
	}



	public static long getStepCount(int MotorCode)

	{
		Befehl_Parameter_3_Befehlscode = 102;
		Befehl_Parameter_4_Motor = (byte)MotorCode;
		letzter_gegebener_Befehl = 102;

		System.out.println("Steuerungsbefehl(Schrittanzahl_abrufen)");

		SerialPort_send();
		Befehl_Parameter_nullsetzen();

		int LowWord_or_HighWord = 0;

		long l=0;


		if (MotorCode == 1 || MotorCode == 2)

		{
			LowWord_or_HighWord = 4;
		}


		if (MotorCode >= 3)

		{
			System.out.println("ERROR: MotorSchritte fr jeden Motor seperat erfragen!");
		}


		// warten, damit das ByteArray "data[]" voll wird!

		try {
				Thread.sleep(500);

			} catch (InterruptedException e) {}


			for (int j=0; (j<data.length)&&(j<LowWord_or_HighWord); j++)

			{
				l |= (((long)data[j])<<(j<<LowWord_or_HighWord-1))&(255L<<(j<<LowWord_or_HighWord-1));
			}

		if (MotorCode == 1)

		{
			System.out.println("Motor 1: " + l);
		}

		if (MotorCode == 2)

		{
			System.out.println("Motor 2: " + l);
		}

		return l;
	}



	public static void setBoardReset(Boolean wirklich_reset)

	{
		Befehl_Parameter_3_Befehlscode = (byte)203;

		if (wirklich_reset.equals(true))

		{
			Befehl_Parameter_4_Motor = (byte)203;
			SerialPort_send();
		}

		System.out.println("Steuerungsbefehl(Board_Reset)");

		Befehl_Parameter_nullsetzen();
	}



	public static String getEepromStatus()

	{
		// warten, damit das ByteArray "data[]" neu beschrieben werden kann!

		try {
				Thread.sleep(500);

			} catch (InterruptedException e) {}


		Befehl_Parameter_3_Befehlscode = (byte)254;
		Befehl_Parameter_4_Motor = (byte)15;			// hier kann man die Anzahl der Rckgabe-Bytes verndern
		letzter_gegebener_Befehl = 254;

		String EepromStatus = "";

		byte[] data = new byte[25];

		System.out.println("Steuerungsbefehl(Eeprom_Status)");

		Methodenaufrufzaehler = 0;		// wird wieder auf 0 gesetzt

		SerialPort_send();
		Befehl_Parameter_nullsetzen();


		// warten, damit das ByteArray "aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[]" voll wird!

		try {
				Thread.sleep(500);

			} catch (InterruptedException e) {}


		// setzt den Methodenaufrufzaehler wieder auf den Startwert!
		Methodenaufrufzaehler = 0;

		EepromStatus = "I2C Slave-ID: " + aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[0] + "\n";


		// SCHRITTMODUS-ABFRAGE

		if (aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[13] == 0)

		{
			EepromStatus = EepromStatus + "Vollschrittmodus dauerhaft eingestellt!\n";
		}

		if (aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[13] == 1)

		{
			EepromStatus = EepromStatus + "Halbschrittmodus dauerhaft eingestellt!\n";
		}


		// SCHNITTSTELLENMODUS ABFRAGE

		if (aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[14] == 1)

		{
			EepromStatus = EepromStatus + "Schnittstellenmodus dauerhaft auf 'intelligent' eingestellt!\n";
		}

		if (aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[14] == 2)

		{
			EepromStatus = EepromStatus + "Schnittstellenmodus dauerhaft auf 'Takt' eingestellt!\n";
		}


		// SCHNITTSTELLENMODUS ABFRAGE

		if (aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[15] == 1)

		{
			EepromStatus = EepromStatus + "CRC-Modus dauerhaft auf 'inaktiv' eingestellt!\n";

		}

		if (aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[15] == 0)

		{
			EepromStatus = EepromStatus + "CRC-Modus dauerhaft auf 'aktiv' eingestellt!\n";
		}


		int Motorstrom1 = ByteToInt(aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[2], aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[1]);
		int Motorstrom2 = ByteToInt(aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[4], aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[3]);

		int Haltestrom1 = ByteToInt(aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[6], aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[5]);
		int Haltestrom2 = ByteToInt(aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[8], aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[7]);

		int Anlaufstrom1 = ByteToInt(aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[10], aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[9]);
		int Anlaufstrom2 = ByteToInt(aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[12], aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray[11]);


		EepromStatus = EepromStatus + "Motorstrom1 : " + Motorstrom1  + " mA\n";
		EepromStatus = EepromStatus + "Motorstrom2 : " + Motorstrom2  + " mA\n";
		EepromStatus = EepromStatus + "Haltestrom1 : " + Haltestrom1  + " mA\n";
		EepromStatus = EepromStatus + "Haltestrom2 : " + Haltestrom2  + " mA\n";
		EepromStatus = EepromStatus + "Anlaufstrom1: " + Anlaufstrom1 + " mA\n";
		EepromStatus = EepromStatus + "Anlaufstrom2: " + Anlaufstrom2 + " mA\n";

		return EepromStatus;
	}



	public static String getBoardVersion()

	{
		// die Rueckmeldung zuerst lschen, dass nichts doppelt gepseichert wird!
		aktuelle_Rueckmeldung = "";

		Befehl_Parameter_3_Befehlscode = (byte)255;
		letzter_gegebener_Befehl = 255;

		System.out.println("Steuerungsbefehl(getBoardVersion)");

		SerialPort_send();

		// warten, damit das ByteArray "data[]" voll wird!

		try {
				Thread.sleep(500);

			} catch (InterruptedException e) {}

		Befehl_Parameter_nullsetzen();

		return aktuelle_Rueckmeldung;
	}



	public static int getLastOrder()

	{
		return letzter_gegebener_Befehl;
	}


////////////////////////////////////////////////////////////////////////////////////////////////////////



	public static void Befehl_Parameter_nullsetzen()

	{
      	// setzte alle Befehl_Parameter wieder auf Null

    	Befehl_Parameter_1_Kennung 		= 33;	// default auf ! -> 33
    	Befehl_Parameter_2_Kennung 		= 35;	// default auf # -> 35

    	Befehl_Parameter_3_Befehlscode 	=  0;	// klassifiziert den Befehl (10 bis 255)

    	Befehl_Parameter_4_Motor 		=  0;	// 1 fr Motor A, 2 fr B und 3 fr A und B
    	Befehl_Parameter_5_Parameter 	=  0;	// je nach Befehl
    	Befehl_Parameter_6_Parameter 	=  0;	// je nach Befehl
    	Befehl_Parameter_7_Parameter 	=  0;	// je nach Befehl
    	Befehl_Parameter_8_Parameter 	=  0;	// je nach Befehl
    	Befehl_Parameter_9_CRC 			=  0;	// 0 fr CRC aus, 1 fr CRC an

	} // Ende: method Befehl_Parameter_nullsetzen()



	////////////////////////////////////////////////////////////////////////////////////////

	static class serialPortEventListener implements SerialPortEventListener

	{
		public void serialEvent(SerialPortEvent event)

		{
			switch (event.getEventType())

			{
				case SerialPortEvent.DATA_AVAILABLE:
				SerialPort_dataOnline();
				break;
				case SerialPortEvent.BI:
				case SerialPortEvent.CD:
				case SerialPortEvent.CTS:
				case SerialPortEvent.DSR:
				case SerialPortEvent.FE:
				case SerialPortEvent.OUTPUT_BUFFER_EMPTY:
				case SerialPortEvent.PE:
				case SerialPortEvent.RI:
				default:
			}

			// die Rckmeldung des Boards wird im String "aktuelle_Rueckmeldung" gespeichert
			aktuelle_Rueckmeldung = aktuelle_Rueckmeldung + aktuelle_Rueckmeldung_Zwischenspeicher;

			/*
			die Rckmeldung des Boards wird in "aktuelle_Rueckmeldung_Zwischenspeicher_ByteArray" gespeichert
			der "Methodenaufrufzaehler" ermittelt die Methodenaufrufe von SerialPort_dataOnline(), wenn die EEPROM-Bytes bentigt werden
			*/

			Methodenaufrufzaehler = Methodenaufrufzaehler +8;


		} // Ende: method serialEvent(event)

	} // Ende: class serialPortEventListener

} // Ende: class Schrittmotorsteuerung



/* Dieses PACKAGE RN_Schrittmotor wurde von C.Malonga erstellt

 ->	natrlich OpenSource und fr alle, die mit der Steuerung RN-Schrittmotor
 	von www.Robotikhardware.de Projekte mit Java an RS232 realisieren wollen :)
 	Viel Spass dabei!
*/