
	/* geschrieben von C.Malonga */

	import RN_Schrittmotor.Schrittmotorsteuerung;	// WICHTIG: dieses Package muss unbedingt geladen werden

	import java.io.*;
	import java.awt.*;

	import javax.swing.*;

	import java.util.*;

	import java.net.*;
	import javax.*;


	//  fr die Nutzung des nachfolgenden Packages muss die Instalationsanweisung
	//  in der README.PDF befolgt werden!

	import javax.comm.*;

	/*

	hier sind noch einmal alle Methoden des Packages "RN_Schrittmotor" aufgelistet:

	public static boolean SerialPort_open()
	public static void SerialPort_close()
	public static void SerialPort_update()
	public static void SerialPort_send()
	public static void SerialPort_dataOnline()

	private static int ByteToInt(byte b0, byte b1)
	private byte[] 	CharToByteArray(char c)

	public static void Motorstrom_festlegen(int MotorCode, int Stromstaerke, int EEPROM)
	public static void Anlaufstrom_festlegen(int MotorCode, int Stromstaerke, int EEPROM)
	public static void Haltestrom_festlegen(int MotorCode, int Stromstaerke, int EEPROM)
	public static void Schrittmodus_festlegen(int Schrittmodus, int EEPROM)
	public static void Schrittzaehler_nullsetzen(int MotorCode)
	public static void Haltestrom_einschalten(int MotorCode)
	public static void Motor_ausschalten(int MotorCode)
	public static void Drehsinn_festlegen(int MotorCode, String Drehsinn)
	public static void Geschwindigkeit_festlegen(int MotorCode, int Zielgschwindigkeit, int Beschleunigung)
	public static void Endlossdrehung_einschalten(int MotorCode)
	public static void Schrittanzahldrehung_einschalten(int MotorCode, int Schrittanzahl)

	public static String getStepperStatus(int MotorCode)
	public static long getStepCount(int MotorCode)
	public static void setBoardReset(Boolean wirklich_reset)

	public static String getEepromStatus()
	public static String getBoardVersion()
	public static int getLastOrder()


	Die aufgelisteten Methoden sind alle 'static'.
	Das bedeutet, sie knenn direkt mit dem Befehl: [Bsp.] -> Schrittmotorsteuerung.Schrittzaehler_nullsetzen(1);
	in die static und main-Methode eingebunden werden.

	Wenn man die Eigenschaft 'static' im Package entfernt, mssen diese Methoden mit: [Bsp.] -> (new Schrittmotorsteuerung()).Schrittzaehler_nullsetzen(1);
	aufgefhrt werden.

	Bei Bedarf einfach in den Java-Bchern ber das Einbinden von Packages die ntigen Schritte nachlesen.

	*/


public class Steuerungssoftware

{
	public Steuerungssoftware()

	{
		System.out.println();
		Schrittmotorsteuerung.SerialPort_open();			// ffne den seriellen Port COM1


	/*		folgendes Szenario wird generiert:

	// VOREINSTELLUNGEN

						aktuelle Firmware erfragen

						2 Sekunden warten, bevor die nchsten Befehle bermittelt werden

		fr Motor1:		Schrittzaehler auf 0 setzen
						Anlaufstrom auf 750mA festlegen (nicht dauerhaft)
						Anlaufstrom auf 650mA festlegen (dauerhaft)
						Drehsinn auf "rechts" festlegen
						Geschwindigkeit auf 75 Schritte pro Sekunde festlegen
						Beschleunigung schalgartig

		fr Motor2:		Grundeinstellungen des Eeproms fr erforderliche Stromwerte verwenden
						Geschwindigkeit auf 60 Schritte pro Sekunde festlegen
						Beschleunigung langsam

	// STEUERUNGSBEFEHLE

		fr Motor1:		bestimmte Anzahl von Schritten festlegen (822 Schritte)

		fr Motor2:		Endlossdrehung starten

	*/


	// VOREINSTELLUNGEN

		String firmware = Schrittmotorsteuerung.getBoardVersion();
		System.out.println();
		System.out.println(firmware);
		System.out.println();


		// warte 2 Sekunden bis die Einstellungen bermittelt werden sollen

		try {
				Thread.sleep(2000);

			} catch (InterruptedException e) {}


		// fr Motor1:
		Schrittmotorsteuerung.Schrittzaehler_nullsetzen(1);
		Schrittmotorsteuerung.Motorstrom_festlegen(1, 750, 0);
		Schrittmotorsteuerung.Anlaufstrom_festlegen(1, 650, 1);
		Schrittmotorsteuerung.Drehsinn_festlegen(1, "rechts");

		// Zielgeschwindigkeit: G = 1000 / (Geschw. +1); fr 75 Schirtte pro Sekunde: 1000 / (75+1) = 13.16
		Schrittmotorsteuerung.Geschwindigkeit_festlegen(1, 13, 0);

		// fr Motor2:
		Schrittmotorsteuerung.Geschwindigkeit_festlegen(2, 16, 50);


	// STEUERUNGSBEFEHLE

		//fr Motor1:
		Schrittmotorsteuerung.Schrittanzahldrehung_einschalten(1, 822);

		//fr Motor2:
		Schrittmotorsteuerung.Endlossdrehung_einschalten(2);



		////////////////////////////////////////////////////////////////////////////////////////////



		// warte 15 Sekunden bis die Motoren ihre Aufgabe erfllt haben

		try {
				Thread.sleep(15000);

			} catch (InterruptedException e) {}


		// rufe Status der Motoren ab:

		long anz_schritte = Schrittmotorsteuerung.getStepCount(1);

		System.out.println();
		System.out.println("StepperStatus(1):");
		System.out.println(anz_schritte);

		String Status = Schrittmotorsteuerung.getStepperStatus(2);

		System.out.println();
		System.out.println("StepperStatus(2):");
		System.out.println(Status);


		// schalte beide Motoren aus!

		Schrittmotorsteuerung.Motor_ausschalten(3);


		// lese die EEPROM-Werte aus:

		String EEPROM = Schrittmotorsteuerung.getEepromStatus();
		System.out.println();
		System.out.println("EEPROM:");
		System.out.println(EEPROM);


		// warte 1 Sekunde bis alle Befehle bermittelt wurden

		try {
				Thread.sleep(1000);

			} catch (InterruptedException e) {}

		Schrittmotorsteuerung.SerialPort_close();		// schliee den seriellen Port COM1


	} // Ende: method Steuerungssoftware()



	public static void main (String [] args)
	throws IOException

	{
		Steuerungssoftware RN = new Steuerungssoftware();

	} // Ende: method main()


} // Ende: class Steuerungssoftware