'##############################################################
'Batteriespannung_ausgeben.bas
'
'Ein  Testprogramm fr die Universalplatine RN-MikroFunk
'
'Das Programm ermittelt die Batteriespannung, also die Spannung
'vor dem Spannungsregler!
'Die Spannung wird ber RS232 ausgegeben.
'Wenn ein USB-Modul an RN-MikroFunk angeschlossen wird,
'dann wird die Zahl ber USB zu einem virtuellen COM Port bertragen
'und kann auch mit allen Programmen oder Terminalprogramm empfangen werden
'
'Bezug: www.robotikhardware.de
'Weitere Beispiele auf DVD oder im www.Roboternetz.de und rn-wissen.de
'######################################################################

$programmer = 12                                            'MCS USB  (Zeile weglassen wenn anderer Programmer)

$PROG &HFF,&HFF,&HD9,&HFF 'Diese Anweisung stellt Fusebits ein


$regfile = "m328pdef.dat"
$framesize = 32
$swstack = 32
$hwstack = 64

$crystal = 8000000                                          'Quarzfrequenz

$baud = 9800                                                'Baudrate (bertragungsgeschwindigkeit)
Baud = 9800



BattAdc Alias Pinc.1
Config BattAdc = Input

Config Adc = Single , Prescaler = 128 , Reference = INTERNAL_1.1


dim adcbattwert as integer
dim r1 as  single
dim r2 as  single
dim uref as single
dim udigit as single
dim vh as single
dim spannung as single


Start Adc
Do
    r1=1000 'Spannungsteiler Widerstand 1 in kOhm
    r2=82 'Spannungsteiler Widerstand 2 in kOhm
    uref=1100 'Referenzspannung im mV 1,1V =1100mV
    vh=r1/r2 'Verhltnis ausrechnen
    udigit=uref/1024
    adcbattwert=Getadc(1)
    spannung= adcbattwert*udigit
    spannung=spannung*vh
    spannung=spannung/1000 'In Volt umrechnen
    'print "ADC-Wert:"; adcbattwert
    print "Spannung V:"; Fusing(spannung , "#.##")

    Wait 1
Loop



