'##############################################################
'IRQ_EmpfaengerRNMikroFunk.bas
'
'Ein  Testprogramm fr die winzige universal Platine RN-MikroFunk und RFM12b
'
'Das Programm demonstriert wie man Daten per Interrupt empfaengt
'Ein anderes Funkmodul sollte Daten mit dem Programmm TestSenderRNMikroFunk
'senden.
'Das Programm ist fr das 433Mhz Modul RFM12b gedacht, diese
'muss bei RN-MikroFunk bestckt sein. Ansonsten muss nur Spannung
'bzw. Batterie angeschlossen werden.
' (c) Frank 2013
'Bezug: www.robotikhardware.de
'Weitere Beispiele auf DVD oder im www.Roboternetz.de und rn-wissen.de
'######################################################################
'Portbelegung:
'keine externe Beschaltung ntig


$programmer = 12    'Bascom USB-ISP-Programmer (Bezug.robotikhardware.de)  (Zeile weglassen wenn anderer Programmer)
$PROG &HFF,&HFF,&HD9,&HFF 'Diese Anweisung stellt Fusebits ein
$regfile = "m328pdef.dat"
$framesize = 32
$swstack = 32
$hwstack = 64
$crystal = 8000000                                          'Quarzfrequenz
$baud = 9800                                                'Baudrate (bertragungsgeschwindigkeit)
Baud = 9800


Declare Sub Rfm12_init
Declare Sub Rfm12_empfange (byval anzahl as word)
Declare Function Spitransfer(byval Dout As Word) As Word



Ss Alias Portb.2
Mosi Alias Portb.3
Miso Alias Pinb.4
Sck Alias Portb.5

Config Ss = Output
Config Mosi = Output
Config Sck = Output

'Interrupt aktivieren
Config Pind.2 = Input                                       'Int0
Portd.2 = 1                                                 'Pullup
Config Int0 = Falling
On Int0 RFM_Funkirq
Enable Int0
Enable Interrupts





Dim IRQ_Eingangsdaten(13) As Byte
Dim Eingangsdaten(13) As Byte
dim eingangsstring as string*12  At Eingangsdaten Overlay
Dim DatenbyteAnzahl As word
dim daten_sind_da as bit

Dim N As Byte
dim r as word 'wird im Interrupt genutzt


print "RN-MikroControl (c) Roboternetz.de start"
Waitms 100
Ss = 1
Sck = 0
Rfm12_init

DatenbyteAnzahl=0
daten_sind_da=0
   'Auf neue Anfangssequenz warten
    r = Spitransfer(&H82c8)  'Empfnger aktivieren
    r = Spitransfer(&Hca83)  'FIFO einstellen/aktivieren
'Hauptprogramm
Do

    if daten_sind_da=1 then
      Print
      Print "Datenbytes:" ; DatenbyteAnzahl
      Print "Als Dezimalzahlen: " ;
      For N = 1 To 12
         Print Eingangsdaten(n);
         Print " ";
      Next N
      print
      Print "Als String: " ;left(eingangsstring,12)
      daten_sind_da=0
    endif


    'an dieser Stelle knnten beliebige Aufgaben nebenher gemacht werden
    'nur ab und zu muss halt geschaut werden ob die Daten schon da sind
    'das sagt hier das Flag  "daten_sind_da" aus

Loop












' ************ Hilfsfunktionen zur Kommunikation mit Funkmodul **************
'  (nhere Infos im Datenblatt des Funkmoduls und Doku von RN-MikroFunk)


' Initialisiere Funkmodul
Sub Rfm12_init
Local Wert As Word
Local X As Word
Local d As Word

  X = 0
  Restore Datainit3                                         'Initialisierungsfolge
  Do
      Read Wert
      D = Spitransfer(wert)
      Incr X
  Loop Until Wert = 0

  Waitms 200
End Sub




Sub Rfm12_empfange(byval anzahl as word)
Local d As Word

  D = Spitransfer(&H82c8)
  D = Spitransfer(&Hca83)
  For N = 1 To anzahl
    Ss = 0
    Do
      Waitus 100
    Loop Until Miso = 1
    D = Spitransfer(&Hb000)
    Eingangsdaten(n) = D
  Next N
  D = Spitransfer(&H8208)
End Sub




Function Spitransfer(byval Dout As Word) As Word
Local Nspi As Integer
Local Dspi As Integer
Local Dmiso As Word
  Ss = 0
  Dmiso = 0
  For Nspi = 1 To 16
    Dspi = Dout And &H8000
    If Dspi = 0 Then
       Mosi = 0
    Else
       Mosi = 1
    End If
    Dout = Dout * 2
    Dmiso = Dmiso * 2
    Dmiso = Dmiso + Miso
    Sck = 1
    Waitus 5
    Sck = 0
  Next Nspi
  Ss = 1
  Spitransfer = Dmiso
End Function


Rfm12_warte:
Ss = 0
Do
Loop Until Miso = 1
Return



'Interrupt vom Funkmodul RFM12b
RFM_Funkirq:
   Incr DatenbyteAnzahl
   r = Spitransfer(&Hb000)
   if DatenbyteAnzahl<=12 then
      IRQ_Eingangsdaten(DatenbyteAnzahl) = r
   else
      r = Memcopy(IRQ_Eingangsdaten(1) , Eingangsdaten(1) , 12)
      daten_sind_da=1
      datenbyteanzahl=0
      r = Spitransfer(&Hca81)  'FIFO FILL zurcksetzen
      r = Spitransfer(&Hca83)  'FIFO FILL aktivieren
      Eifr.intf0 = 1                                          'Eventuell anstehenden Interrupt loeschen
   endif
return



End


'Funkmodul Initialisierungsdaten  9600 Baud


Datainit3:
Data &H80D7%                                                'OK Enable: 433 Mhz;XTAL cap=12pf; TX-Register; RX-Fifo
Data &H82D9%                                                'OK Enable: Receiver; Crystal Osc; Base Band Block; Synthesizer
                                                             'Disable Low-bat Detector; Transmitter; Wake-Up-Timer; Clock output Pin

Data &HA67C%                                                'OK &Ha67c=frequenz 434,15 Mhz  oder z.B. &HA538 fr 433,34 Mhz

Data &HC623%                                                'OK &Hc647=Datenrate '4.8kbps;  C623=9600kbps;  C611 =19200

Data &H90C0%                                                'OK LNA Gain=MAX; Pin=nInt; RX Bandwidth=67 khz; VDI=Fast; DRSSI=-103 dB

Data &HC2AC%                                                'OK Fiter=Digital; Recover Mode=Auto; Quality Threshold=4; Recovery Speed=Slow

Data &HCA80%                                                'OK FIFO INT Level=8; Sync on=2;Fifo Fill Start=Sync; Reset Sensitivity=High;
                                                            'Disable:FIFO Fill Enabled

Data &HC483%                                                'OK Enable: AFC Mode; AFC; Frequency Offset Register
                                                            'Disable: High Accuracy; Strobe

Data &H9820%                                                'OK Frequenz Shift=POS; Power Out=0 dB; Deviation=45 khz

Data &HE000%                                                'OK WakeUp-Timer=0ms

Data &HC800%                                                'OK Duty Cycle = Infinity % OFF

Data &HC000%                                                'OK Low batterie=2,2V; Clock Pin=1 Mhz

Data &HCED4%                                                'OK Synchron Pattern

Data &HCC57%                                                'PLL Settings

Data &H0000%                                                'Status lesen irqs zurckstellen

Data 0%                                                     'ende initialisierung