'##############################################################
'Stromspar_SenderRNMikroFunk.bas
'
'Ein  Testprogramm fr die winzige universal Platine RN-MikroFunk
'
'Dieses Programm demonstriert den Stromsparmodi. Das Programm
'bertrgt sendet per Funk wieder den String "RN-MikroFunk"
'Danach schaltet es aber das Funkmodul und alle Funktionen
'komplett aus und geht auch selbst in den Schalfmodus!
'Dadurch braucht das Board nun nur noch ca. 0,01mA Strom
'nach 8 Sekunden weckt es sich selbst ber den vorher konfigurierten Watchdog
'und macht da weiter wo es aufgehrt hat. Es sendet also alle 8 Sekunden
'den String aus und schlft zwischendurch!
'
'Bezug: www.robotikhardware.de
'Weitere Beispiele auf DVD oder im www.Roboternetz.de und rn-wissen.de
'######################################################################

'Portbelegung:
'keine externe Beschaltung ntig


$programmer = 12                                            'MCS USB  (Zeile weglassen wenn anderer Programmer)
$PROG &HFF,&HFF,&HD9,&HFF 'Diese Anweisung stellt Fusebits ein
$regfile = "m328pdef.dat"
$framesize = 32
$swstack = 32
$hwstack = 64
$crystal = 8000000                                          'Quarzfrequenz
$baud = 9800                                                'Baudrate (bertragungsgeschwindigkeit)
Baud = 9800

Declare Sub Rfm12_init
Declare Sub Rfm12_senden(byval Anzahl As Integer)
Declare Function Spitransfer(byval Dout As Word) As Word


Ss Alias Portb.2
Mosi Alias Portb.3
Miso Alias Pinb.4
Sck Alias Portb.5

Config Ss = Output
Config Mosi = Output
Config Sck = Output



'Hier werden die zu sendenten Daten abgelegt
Dim Ausgabedaten(200) As Byte
dim ausgabestring as string*199  At Ausgabedaten Overlay
dim r as word

Ss = 1
Sck = 0
Rfm12_init

Config Watchdog = 8192
Enable Wdt
Enable Interrupts

'Hauptprogramm
Do
 Reset Watchdog

 r=Spitransfer(&H8201)     'Funkmodul komplett schlafen legen /alles abschalten
 Powerdown
 ausgabestring="RN-MikroFunk"
 call Rfm12_senden(12)


Loop




' ************ Hilfsfunktionen zur Kommunikation mit Funkmodul **************
'  (nhere Infos im Datenblatt des Funkmoduls und in der Dokumentation von RN-MikroFunk)



' Initialisiere Funkmodul
Sub Rfm12_init
Local Wert As Word
Local X As Word
Local d As Word

  X = 0
  Restore Datainit3                  'Initialisierungsfolge
  Do
      Read Wert
      D = Spitransfer(wert)
      Incr X
  Loop Until Wert = 0
  Waitms 200
End Sub






Sub Rfm12_senden(byval Anzahl As Integer)
local n as byte
Local d As Word

  D = Spitransfer(&H8238)                                   'Enable Transmitter; enable Synthesizer ;enable Crystal Osc
  Gosub Rfm12_warte
  D = Spitransfer(&Hb8aa)
  Gosub Rfm12_warte
  D = Spitransfer(&Hb8aa)
  Gosub Rfm12_warte
  D = Spitransfer(&Hb8aa)
  Gosub Rfm12_warte
  D = Spitransfer(&Hb82d)
  Gosub Rfm12_warte
  D = Spitransfer(&Hb8d4)
  For N = 1 To Anzahl
    Gosub Rfm12_warte
    D = &HB800 + Ausgabedaten(n)
    D = Spitransfer(d)
  Next N
  Gosub Rfm12_warte
  D = Spitransfer(&Hb8aa)
  Gosub Rfm12_warte
  D = Spitransfer(&Hb8aa)
  Gosub Rfm12_warte
  D = Spitransfer(&H8208)                                   'disable transmitter und  receiver
End Sub



Function Spitransfer(byval Dout As Word) As Word
Local Nspi As Integer
Local Dspi As Integer
Local Dmiso As Word
  Ss = 0
  Dmiso = 0
  For Nspi = 1 To 16
    Dspi = Dout And &H8000
    If Dspi = 0 Then
       Mosi = 0
    Else
       Mosi = 1
    End If
    Dout = Dout * 2
    Dmiso = Dmiso * 2
    Dmiso = Dmiso + Miso
    Sck = 1
    Waitus 5
    Sck = 0
  Next Nspi
  Ss = 1
  Spitransfer = Dmiso
End Function



Rfm12_warte:
Ss = 0
Do
Loop Until Miso = 1
Return



'End ' programmende



'Funkmodul Initialisierungsdaten mit 9600 Baud

Datainit3:
Data &H80D7%                                                'OK Enable: 433 Mhz;XTAL cap=12pf; TX-Register; RX-Fifo
Data &H82D9%                                                'OK Enable: Receiver; Crystal Osc; Base Band Block; Synthesizer
                                                             'Disable Low-bat Detector; Transmitter; Wake-Up-Timer; Clock output Pin

Data &HA67C%                                                'OK &Ha67c=frequenz 434,15 Mhz  oder z.B. &HA538 fr 433,34 Mhz

Data &HC623%                                                'OK &Hc647=Datenrate '4.8kbps;  C623=9600kbps;  C611 =19200

Data &H90C0%                                                'OK LNA Gain=MAX; Pin=nInt; RX Bandwidth=67 khz; VDI=Fast; DRSSI=-103 dB

Data &HC2AC%                                                'OK Fiter=Digital; Recover Mode=Auto; Quality Threshold=4; Recovery Speed=Slow

Data &HCA80%                                                'OK FIFO INT Level=8; Sync on=2;Fifo Fill Start=Sync; Reset Sensitivity=High;
                                                            'Disable:FIFO Fill Enabled

Data &HC483%                                                'OK Enable: AFC Mode; AFC; Frequency Offset Register
                                                            'Disable: High Accuracy; Strobe

Data &H9820%                                                'OK Frequenz Shift=POS; Power Out=0 dB; Deviation=45 khz

Data &HE000%                                                'OK WakeUp-Timer=0ms

Data &HC800%                                                'OK Duty Cycle = Infinity % OFF

Data &HC000%                                                'OK Low batterie=2,2V; Clock Pin=1 Mhz

Data &HCED4%                                                'OK Synchron Pattern

Data &HCC57%                                                'PLL Settings

Data &H0000%                                                'Status lesen irqs zurckstellen

Data 0%                                                     'ende initialisierung