/*
   PretzelBoard-SRF02-Server
   Beispiel für PretzelBoard - Arduino Board mit WLAN
   Beschreibung des Boards und Beispiels auf der Webseite:
   http://www.mikrocontroller-elektronik.de/
   Aufgabe:
   Entfernung einer Flüssigkeit messen und 
   daraus Tankinhalt berechnen und auf einer Webseite anzeigen
 */
 


#define SSID "ssid"
#define PASSWORD "wlanpasswort"

#define LED 9
#define LED_WLAN 13

#define DEBUG true

#include <Wire.h> 
#include <SoftwareSerial.h>

#define TANKINHALT  4500
#define TANKHOEHE   155

#define SRF_ADDRESS         0x70                  // Standard Addresse des Ultraschallsensor SRF02 (7 Bit)
#define CMD                 (byte)0x00   
#define RANGEBYTE           0x02            

const char site[] PROGMEM = {"<HTML><BODY><center><table style=\"font-size:24px;padding:5px;border-style:solid;border-width:3px;border-color:red;background-color:#3e3e3e;color:white;\">  <tr>    <th   style=\"color:yellow;\" colspan=\"2\">REGENWASSERTANK KELLER</th>  </tr>  <tr>    <td >INHALT (Liter):</td>    <td >[xxx]</td>  </tr>  <tr>    <td style=\"font-size:11px;padding:10px\" colspan=\"2\">Die gemessene Entfernung betrug [ENTFERNUNG] cm</td>  </tr></table></center>"};
                   
byte highByte = 0x00;                             // Variable für i2c Entfernungsabfrage
byte lowByte = 0x00;                              // Variable für i2c Entfernungsabfrage

SoftwareSerial esp8266(11, 12); // RX, TX

void setup() {

  Serial.begin(19200);
  esp8266.begin(19200);
  pinMode(LED, OUTPUT);
  
  if (!espConfig()) serialDebug();
  else digitalWrite(LED_WLAN, HIGH);

  if (configTCPServer())  debug("Server Aktiv"); else debug("Server Error");

  Wire.begin();                                   //i2C initialisieren
  delay(100);                                     
  int softRev = getSRF02Version();    
  Serial.write("PretzelBoard Beispiel von http://www.mikrocontroller-elektronik.de\n");
  Serial.write("SRF02 Firmware Version:");
  Serial.print(softRev, DEC) ;
  Serial.write("\n");     
}


void loop() {
  String xBuffer;
  if (esp8266.available()) // check if the esp is sending a message
  {
    if (esp8266.find("+IPD,"))
    {
      debug("Incomming Request");
      int connectionId = esp8266.parseInt();

      if (sendWebsite(connectionId, createWebsite())) debug("Website send OK"); else debug("Website send Error");
    }

  }
}

boolean sendWebsite(int connectionId, String webpage)
{
  boolean success = true;

  if (sendCom("AT+CIPSEND=" + String(connectionId) + "," + String(webpage.length()), ">"))
  {
    esp8266.print(webpage);
    esp8266.find("SEND OK");
    success &= sendCom("AT+CIPCLOSE=" + String(connectionId), "OK");
  }
  else
  {
    success = false;
  }
  return success;
}


String createWebsite()
{
  String xBuffer;

  for (int i = 0; i <= sizeof(site); i++)
  {
    char myChar = pgm_read_byte_near(site + i);
    xBuffer += myChar;
  }
  int entfernung = getSRF02Entfernung();      //Software Version des Sensors SRF02 abfragen
  int fuellstand=TANKHOEHE -entfernung;       //Wir brauchen ja Füllstand vom Boden gemessen
  
  long zw=(long) TANKINHALT * fuellstand;
  int inhalt=(int)(zw / TANKHOEHE);
  
  xBuffer.replace("[xxx]", String(inhalt));
  xBuffer.replace("[ENTFERNUNG]", String(entfernung));
  //Serial.println(xBuffer);    
       

  return xBuffer;
}

//-----------------------------------------Config ESP8266------------------------------------

boolean espConfig()
{
  boolean success = true;
  esp8266.setTimeout(5000);
  success &= sendCom("AT+RST", "ready");
  esp8266.setTimeout(1000);
  if (configStation(SSID, PASSWORD)) {
    success &= true;
    debug("WLAN Connected");
    debug("My IP is:");
    debug(sendCom("AT+CIFSR"));
  }
  else
  {
    success &= false;
  }
  //shorter Timeout for faster wrong UPD-Comands handling
  success &= sendCom("AT+CIPMODE=0", "OK");  //So rum scheit wichtig!
  success &= sendCom("AT+CIPMUX=0", "OK");

  return success;
}

boolean configTCPServer()
{
  boolean success = true;

  success &= (sendCom("AT+CIPMUX=1", "OK"));
  success &= (sendCom("AT+CIPSERVER=1,80", "OK"));

  return success;

}

boolean configTCPClient()
{
  boolean success = true;

  success &= (sendCom("AT+CIPMUX=0", "OK"));
  //success &= (sendCom("AT+CIPSERVER=1,80", "OK"));

  return success;

}


boolean configStation(String vSSID, String vPASSWORT)
{
  boolean success = true;
  success &= (sendCom("AT+CWMODE=1", "OK"));
  esp8266.setTimeout(20000);
  success &= (sendCom("AT+CWJAP=\"" + String(vSSID) + "\",\"" + String(vPASSWORT) + "\"", "OK"));
  esp8266.setTimeout(1000);
  return success;
}

boolean configAP()
{
  boolean success = true;

  success &= (sendCom("AT+CWMODE=2", "OK"));
  success &= (sendCom("AT+CWSAP=\"NanoESP\",\"\",5,0", "OK"));

  return success;
}

boolean configUDP()
{
  boolean success = true;

  success &= (sendCom("AT+CIPMODE=0", "OK"));
  success &= (sendCom("AT+CIPMUX=0", "OK"));
  success &= sendCom("AT+CIPSTART=\"UDP\",\"192.168.255.255\",90,91,2", "OK"); //Importand Boradcast...Reconnect IP
  return success;
}

//-----------------------------------------------Controll ESP-----------------------------------------------------

boolean sendUDP(String Msg)
{
  boolean success = true;

  success &= sendCom("AT+CIPSEND=" + String(Msg.length() + 2), ">");    //+",\"192.168.4.2\",90", ">");
  if (success)
  {
    success &= sendCom(Msg, "OK");
  }
  return success;
}


boolean sendCom(String command, char respond[])
{
  esp8266.println(command);
  if (esp8266.findUntil(respond, "ERROR"))
  {
    return true;
  }
  else
  {
    debug("ESP SEND ERROR: " + command);
    return false;
  }
}

String sendCom(String command)
{
  esp8266.println(command);
  return esp8266.readString();
}



//-------------------------------------------------Debug Functions------------------------------------------------------
void serialDebug() {
  while (true)
  {
    if (esp8266.available())
      Serial.write(esp8266.read());
    if (Serial.available())
      esp8266.write(Serial.read());
  }
}

void debug(String Msg)
{
  if (DEBUG)
  {
    Serial.println(Msg);
  }
}

//-------------------------------------------------SRF02 Functionen------------------------------------------------------

int getSRF02Version(){                             // Firmware Version des SRF02 auslesen
  
  Wire.beginTransmission(SRF_ADDRESS);             
  Wire.write(CMD);                                 
  Wire.endTransmission();
  
  Wire.requestFrom(SRF_ADDRESS, 1);                
  while(Wire.available() < 0);                     
  int software = Wire.read();                      
    
  return(software);                               
  
}

int getSRF02Entfernung(){                          // Entfernung in cm messen
  
  int range = 0; 
  
  Wire.beginTransmission(SRF_ADDRESS);             
  Wire.write(CMD);                                 // Sende Befehl
  Wire.write(0x51);                                // Starte Messung
  Wire.endTransmission();
  
  delay(100);                                      // Warte etwas, bis Messung abgeschlossen
  
  Wire.beginTransmission(SRF_ADDRESS);             // Lese Entfernung aus
  Wire.write(RANGEBYTE);                           
  Wire.endTransmission();
  
  Wire.requestFrom(SRF_ADDRESS, 2);                
  while(Wire.available() < 2);                     
  highByte = Wire.read();                          
  lowByte = Wire.read();                           

  range = (highByte << 8) + lowByte;               
  
  return(range);                                   
}
