'###################################################
'rn_propeller_main.bas
'Dieses Programm ist fr das Projekt RN-PropellerClock
'50 drehende Leds erzeugen ein Bild
'Boardbeschreibung Roboternetz.de oder robotikhardware.de
'Verwendeter Compiler Bascom V 1.11.9.3
'
'Aufgabe:
'Programmiert werden vornehmlich drei Chips vom Typ TLC59116

'
'Autor: Frank
'Weitere Beispiele und Beschreibung der Hardware
'unter http://www.Roboternetz.de bzw. robotikhardware.de
'###################################################


$programmer = 12                                            'MCS USB  (Zeile weglassen wenn anderer Programmer)
$regfile = "m644def.dat"
$crystal = 20000000                                         'Quarzfrequenz
$baud = 9600
$hwstack = 80
$framesize = 80
$swstack = 80

$lib "I2C_TWI.LBX"
Config Twi = 1100000                                        ' wanted clock frequency
Config Scl = Portc.0                                        'Ports fuer IIC-Bus
Config Sda = Portc.1


Declare Sub Printzeichenoben(byval Zeichen As Byte , Byval Zeile As Byte)
Declare Sub Printzeichenunten(byval Zeichen As Byte , Byval Zeile As Byte)
Declare Sub Printstring(byval Text As String , Byval Zeile As Byte)
Declare Sub Clearbild()


Const An = 0
Const Aus = 1

'I2C Bus Slave Adressen
Const Tlc1 = &B11000010
Const Tlc2 = &B11000000
Const Tlc3 = &B11000100


'TLC Register
Const Ledout0 = &H14 Or 128






I2cinit


Config Adc = Single , Prescaler = Auto , Reference = Avcc
Start Adc


Config Int1 = Falling                                       'Rundenstart duch Hallsensor ermitteln


Config Pind.4 = Output
Led49_gruen Alias Portd.4

Config Pind.7 = Output
Led50_gelb Alias Portd.7

Config Pind.5 = Output
Irled Alias Portd.5

Config Pind.3 = Input
Hallsensor Alias Pind.3

Config Pind.6 = Input
Spannung Alias Pind.6


Dim Helligkeit As Word
Dim Stopzeit As Word
Dim Runden As Word
Dim Timervorgabe As Word
Dim Spalte As Byte

Dim Bildspeicher(1608) As Byte
Dim Pbildbyte As Word
Dim Aktpos As Word

'Lokale Variablen bei Zeichensatzauslesung
Dim Iz As Word
Dim Dmatrix As Byte
Dim It As Byte
Dim Zz As Byte
Dim Text As String * 100
Dim Temptext As String * 100


'TLC einschalten (Sleep out)
I2cstart                                                    'start condition
I2cwbyte Tlc1
I2cwbyte 0                                                  'Register
I2cwbyte 0
I2cstop

I2cstart                                                    'start condition
I2cwbyte Tlc2
I2cwbyte 0                                                  'Register
I2cwbyte 0
I2cstop




I2cstart                                                    'start condition
I2cwbyte Tlc1
I2cwbyte Ledout0                                            'Register
I2cwbyte &B01010101


I2cstart                                                    'start condition
I2cwbyte Tlc2
I2cwbyte Ledout0                                            'Register
I2cwbyte &B01010101
I2cwbyte &B01010101
I2cwbyte &B01010101
I2cwbyte &B01010101
I2cstop



On Int1 Rundenstart

Config Timer1 = Timer , Prescale = 1
Timervorgabe = 65500                                        '65036                                        '64536                                        '49911
On Timer1 Spalten_irq
Disable Timer1

Enable Int1
Enable Interrupts
                                                 'enable the interrupt


Do
Led50_gelb = An

Clearbild

Text = "Die"
Printstring Text , 1

Text = "Elektronik"
Printstring Text , 2


Text = "Community"
Printstring Text , 3

Text = "Roboternetz.de"
Printstring Text , 4

Wait 1
Clearbild

Text = "Test der"
Printstring Text , 1

Text = "Propeller"
Printstring Text , 2


Text = "Darstellung"
Printstring Text , 3

Text = "50 LED`s" "
Printstring Text , 4

Wait 1
Clearbild

Text = "Platine"
Printstring Text , 1

Text = "auf Anfrage"
Printstring Text , 2


Text = "Robotik"
Printstring Text , 3

Text = "hardware.de"
Printstring Text , 4


Wait 1
Clearbild
Toggle Led49_gruen
Loop



' *** Interrupt Routine wird aktiviert wenn Hallsensor Magnet erkennt
' *** also wenn Runde startet
Rundenstart:

    Pbildbyte = 1
    Spalte = 1
    Timer1 = Timervorgabe
    Enable Timer1
    Disable Int1
Return






Spalten_irq:
  Timer1 = Timervorgabe


   I2cstart                                                 'start condition
   I2cwbyte Tlc2
   I2cwbyte Ledout0                                         'Register
   I2cwbyte Bildspeicher(pbildbyte)
   Incr Pbildbyte
   I2cwbyte Bildspeicher(pbildbyte)
   Incr Pbildbyte
   I2cwbyte Bildspeicher(pbildbyte)
   Incr Pbildbyte
   I2cwbyte Bildspeicher(pbildbyte)
   Incr Pbildbyte

 I2cstart                                                 'start condition
   I2cwbyte Tlc1
   I2cwbyte Ledout0                                         'Register
   I2cwbyte Bildspeicher(pbildbyte)
   Incr Pbildbyte
   I2cwbyte Bildspeicher(pbildbyte)
   Incr Pbildbyte
   I2cwbyte Bildspeicher(pbildbyte)
   Incr Pbildbyte
   I2cwbyte Bildspeicher(pbildbyte)
   Incr Pbildbyte
   I2cstop



  If Spalte > 200 Then
     Disable Timer1

      I2cstart                                              'start condition
      I2cwbyte Tlc1
      I2cwbyte Ledout0                                      'Register
      I2cwbyte 0
      I2cwbyte 0
      I2cwbyte 0
      I2cwbyte 0

      I2cstart                                              'start condition
      I2cwbyte Tlc2
      I2cwbyte Ledout0                                      'Register
      I2cwbyte 0
      I2cwbyte 0
      I2cwbyte 0
      I2cwbyte 0

      I2cstop
      Enable Int1
  End If
  Incr Spalte
Return




Sub Clearbild()                                             'Bildspeicher loeschen
Local Le As Word
  For Le = 1 To 1608
      Bildspeicher(le) = 0
  Next
End Sub


'Gibt einen String aus Zeile 1 und 2 ist oben
'und Zeile 3 und 4 unten
Sub Printstring(byval Text As String , Byval Zeile As Byte) 'Eine Art Print Befehl zum Ausgeben von Text
Local Le As Word
Local Zei As Byte
Local S As String * 1
Local Ls As Word


  If Zeile = 1 Or Zeile = 2 Then
    Aktpos = 1601
  Else
    Aktpos = 1
  End If

  Temptext = ""
  Ls = 0
  Le = Len(text)
  If Le < 12 Then
    Ls = 12 - Le
    Ls = Ls / 2
  End If

  If Ls > 0 Then
    Temptext = Space(ls) + Text
  Else
    Temptext = Text
  End If

  Le = Len(temptext)
  For Zz = 1 To Le
     S = Mid(temptext , Zz , 1)
     Zei = Asc(s)
     If Zeile = 1 Or Zeile = 2 Then
        Printzeichenoben Zei , Zeile
     Else
        Printzeichenunten Zei , Zeile
     End If
     Print S
  Next Zz

End Sub



Sub Printzeichenunten(byval Zeichen As Byte , Byval Zeile As Byte)
Iz = Zeichen
Iz = Iz * 8

If Zeile = 4 Then
     For It = 1 To 8
       Dmatrix = Lookup(iz , Zeichensatz)
       Bildspeicher(aktpos) = 0
       If Dmatrix.3 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B01000000
       End If
       If Dmatrix.2 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00010000
       End If
       If Dmatrix.1 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000100
       End If
       If Dmatrix.0 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000001
       End If

       Incr Aktpos
       Bildspeicher(aktpos) = 0

       If Dmatrix.7 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B01000000
       End If
       If Dmatrix.6 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00010000
       End If
       If Dmatrix.5 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000100
       End If
       If Dmatrix.4 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000001
       End If
       Aktpos = Aktpos + 7
       Incr Iz
   Next It
End If

If Zeile = 3 Then
     For It = 1 To 8
       Dmatrix = Lookup(iz , Zeichensatz)
       Incr Aktpos
       Incr Aktpos
       Bildspeicher(aktpos) = 0
       If Dmatrix.3 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B01000000
       End If
       If Dmatrix.2 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00010000
       End If
       If Dmatrix.1 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000100
       End If
       If Dmatrix.0 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000001
       End If

       Incr Aktpos
       Bildspeicher(aktpos) = 0

       If Dmatrix.7 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B01000000
       End If
       If Dmatrix.6 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00010000
       End If
       If Dmatrix.5 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000100
       End If
       If Dmatrix.4 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000001
       End If
       Aktpos = Aktpos + 5
       Incr Iz
   Next It
End If

   Aktpos = Aktpos + 8
End Sub


Sub Printzeichenoben(byval Zeichen As Byte , Byval Zeile As Byte)
Iz = Zeichen
Iz = Iz * 8

If Zeile = 1 Then
     For It = 1 To 8
       Dmatrix = Lookup(iz , Zeichensatz)
       Bildspeicher(aktpos) = 0
       If Dmatrix.4 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B01000000
       End If
       If Dmatrix.5 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00010000
       End If
       If Dmatrix.6 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000100
       End If
       If Dmatrix.7 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000001
       End If

       Incr Aktpos
       Bildspeicher(aktpos) = 0

       If Dmatrix.0 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B01000000
       End If
       If Dmatrix.1 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00010000
       End If
       If Dmatrix.2 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000100
       End If
       If Dmatrix.3 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000001
       End If

       Aktpos = Aktpos - 9
       Incr Iz
   Next It
End If

If Zeile = 2 Then
     For It = 1 To 8
       Dmatrix = Lookup(iz , Zeichensatz)
       Incr Aktpos
       Incr Aktpos
       Bildspeicher(aktpos) = 0
       If Dmatrix.4 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B01000000
       End If
       If Dmatrix.5 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00010000
       End If
       If Dmatrix.6 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000100
       End If
       If Dmatrix.7 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000001
       End If

       Incr Aktpos
       Bildspeicher(aktpos) = 0

       If Dmatrix.0 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B01000000
       End If
       If Dmatrix.1 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00010000
       End If
       If Dmatrix.2 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000100
       End If
       If Dmatrix.3 = 1 Then
         Bildspeicher(aktpos) = Bildspeicher(aktpos) Or &B00000001
       End If

       Aktpos = Aktpos - 11
       Incr Iz
   Next It
End If

   Aktpos = Aktpos - 8
End Sub





'Zeichensatz 8x8 vertikal
Zeichensatz:
Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00  ' &H00
Data &H7E , &H81 , &HA9 , &H8D , &H8D , &HA9 , &H81 , &H7E  ' &H01
Data &H7E , &HFF , &HD7 , &HF3 , &HF3 , &HD7 , &HFF , &H7E  '  &H02
Data &H70 , &HF8 , &HFC , &H7E , &HFC , &HF8 , &H70 , &H00  '  &H03
Data &H10 , &H38 , &H7C , &HFE , &H7C , &H38 , &H10 , &H00  '  &H04
Data &H1C , &H5C , &HF9 , &HFF , &HF9 , &H5C , &H1C , &H00  '  &H05
Data &H08 , &H1C , &H3D , &HFF , &H3D , &H1C , &H08 , &H00  '  &H06
Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00  '  &H07
Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00  '  &H08
Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00  '  &H09
Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00  '  &H0a
Data &H0E , &H1F , &H11 , &H11 , &HBF , &HFE , &HE0 , &HF0  '  &H0b
Data &H00 , &H72 , &HFA , &H8F , &H8F , &HFA , &H72 , &H00  '  &H0c
Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00  '  &H0d
Data &H03 , &HFF , &HFE , &HA0 , &HA0 , &HA6 , &HFE , &HFC  '  &H0e
Data &H99 , &H5A , &H3C , &HE7 , &HE7 , &H3C , &H5A , &H99  '  &H0f
Data &HFE , &H7C , &H7C , &H38 , &H38 , &H10 , &H10 , &H00  '  &H10
Data &H10 , &H10 , &H38 , &H38 , &H7C , &H7C , &HFE , &H00  '  &H11
Data &H00 , &H24 , &H66 , &HFF , &HFF , &H66 , &H24 , &H00  '  &H12
Data &H00 , &HFA , &HFA , &H00 , &H00 , &HFA , &HFA , &H00  '  &H13
Data &H60 , &HF0 , &H90 , &HFE , &HFE , &H80 , &HFE , &HFE  '  &H14
Data &H5B , &HFD , &HA5 , &HA5 , &HBF , &H9A , &HC0 , &H40  '  &H15
Data &H00 , &H0E , &H0E , &H0E , &H0E , &H0E , &H0E , &H00  '  &H16
Data &H01 , &H29 , &H6D , &HFF , &HFF , &H6D , &H29 , &H01  '  &H17
Data &H00 , &H20 , &H60 , &HFE , &HFE , &H60 , &H20 , &H00  '  &H18
Data &H00 , &H08 , &H0C , &HFE , &HFE , &H0C , &H08 , &H00  '  &H19
Data &H10 , &H10 , &H10 , &H54 , &H7C , &H38 , &H10 , &H00  '  &H1a
Data &H10 , &H38 , &H7C , &H54 , &H10 , &H10 , &H10 , &H00  '  &H1b
Data &H3C , &H3C , &H04 , &H04 , &H04 , &H04 , &H04 , &H00  '  &H1c
Data &H10 , &H38 , &H7C , &H10 , &H10 , &H7C , &H38 , &H10  '  &H1d
Data &H0C , &H1C , &H3C , &H7C , &H7C , &H3C , &H1C , &H0C  '  &H1e
Data &H60 , &H70 , &H78 , &H7C , &H7C , &H78 , &H70 , &H60  '  &H1f
Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00  '  &H20
Data &H00 , &H60 , &HFA , &HFA , &H60 , &H00 , &H00 , &H00  '  &H21
Data &H00 , &HE0 , &HE0 , &H00 , &HE0 , &HE0 , &H00 , &H00  '  &H22
Data &H28 , &HFE , &HFE , &H28 , &HFE , &HFE , &H28 , &H00  '  &H23
Data &H24 , &H74 , &HD6 , &HD6 , &H5C , &H48 , &H00 , &H00  '  &H24
Data &H62 , &H66 , &H0C , &H18 , &H30 , &H66 , &H46 , &H00  '  &H25
Data &H0C , &H5E , &HF2 , &HBA , &HEC , &H5E , &H12 , &H00  '  &H26
Data &H20 , &HE0 , &HC0 , &H00 , &H00 , &H00 , &H00 , &H00  '  &H27
Data &H00 , &H38 , &H7C , &HC6 , &H82 , &H00 , &H00 , &H00  '  &H28
Data &H00 , &H82 , &HC6 , &H7C , &H38 , &H00 , &H00 , &H00  '  &H29
Data &H10 , &H54 , &H7C , &H38 , &H38 , &H7C , &H54 , &H10  '  &H2a
Data &H10 , &H10 , &H7C , &H7C , &H10 , &H10 , &H00 , &H00  '  &H2b
Data &H00 , &H05 , &H07 , &H06 , &H00 , &H00 , &H00 , &H00  '  &H2c
Data &H10 , &H10 , &H10 , &H10 , &H10 , &H10 , &H00 , &H00  '  &H2d
Data &H00 , &H00 , &H06 , &H06 , &H00 , &H00 , &H00 , &H00  '  &H2e
Data &H06 , &H0C , &H18 , &H30 , &H60 , &HC0 , &H80 , &H00  '  &H2f
Data &H7C , &HFE , &H9A , &HB2 , &HFE , &H7C , &H00 , &H00  '  &H30
Data &H42 , &H42 , &HFE , &HFE , &H02 , &H02 , &H00 , &H00  '  &H31
Data &H46 , &HCE , &H9A , &H92 , &HF6 , &H66 , &H00 , &H00  '  &H32
Data &H44 , &HC6 , &H92 , &H92 , &HFE , &H6C , &H00 , &H00  '  &H33
Data &H18 , &H38 , &H68 , &HC8 , &HFE , &HFE , &H08 , &H00  '  &H34
Data &HE4 , &HE6 , &HA2 , &HA2 , &HBE , &H9C , &H00 , &H00  '  &H35
Data &H3C , &H7E , &HD2 , &H92 , &H9E , &H0C , &H00 , &H00  '  &H36
Data &HC0 , &HC6 , &H8E , &H98 , &HF0 , &HE0 , &H00 , &H00  '  &H37
Data &H6C , &HFE , &H92 , &H92 , &HFE , &H6C , &H00 , &H00  '  &H38
Data &H60 , &HF2 , &H92 , &H96 , &HFC , &H78 , &H00 , &H00  '  &H39
Data &H00 , &H00 , &H36 , &H36 , &H00 , &H00 , &H00 , &H00  '  &H3a
Data &H00 , &H05 , &H37 , &H36 , &H00 , &H00 , &H00 , &H00  '  &H3b
Data &H10 , &H38 , &H6C , &HC6 , &H82 , &H00 , &H00 , &H00  '  &H3c
Data &H28 , &H28 , &H28 , &H28 , &H28 , &H28 , &H00 , &H00  '  &H3d
Data &H00 , &H82 , &HC6 , &H6C , &H38 , &H10 , &H00 , &H00  '  &H3e
Data &H40 , &HC0 , &H8A , &H9A , &HF0 , &H60 , &H00 , &H00  '  &H3f
Data &H7C , &HFE , &H82 , &HBA , &HBA , &HF8 , &H78 , &H00  '  &H40
Data &H3E , &H7E , &HC8 , &HC8 , &H7E , &H3E , &H00 , &H00  '  &H41
Data &H82 , &HFE , &HFE , &H92 , &H92 , &HFE , &H6C , &H00  '  &H42
Data &H38 , &H7C , &HC6 , &H82 , &H82 , &HC6 , &H44 , &H00  '  &H43
Data &H82 , &HFE , &HFE , &H82 , &HC6 , &HFE , &H38 , &H00  '  &H44
Data &H82 , &HFE , &HFE , &H92 , &HBA , &H82 , &HC6 , &H00  '  &H45
Data &H82 , &HFE , &HFE , &H92 , &HB8 , &H80 , &HC0 , &H00  '  &H46
Data &H38 , &H7C , &HC6 , &H82 , &H8A , &HCE , &H4E , &H00  '  &H47
Data &HFE , &HFE , &H10 , &H10 , &HFE , &HFE , &H00 , &H00  '  &H48
Data &H00 , &H82 , &HFE , &HFE , &H82 , &H00 , &H00 , &H00  '  &H49
Data &H0C , &H0E , &H02 , &H82 , &HFE , &HFC , &H80 , &H00  '  &H4a
Data &H82 , &HFE , &HFE , &H10 , &H38 , &HEE , &HC6 , &H00  '  &H4b
Data &H82 , &HFE , &HFE , &H82 , &H02 , &H06 , &H0E , &H00  '  &H4c
Data &HFE , &HFE , &H60 , &H30 , &H60 , &HFE , &HFE , &H00  '  &H4d
Data &HFE , &HFE , &H60 , &H30 , &H18 , &HFE , &HFE , &H00  '  &H4e
Data &H38 , &H7C , &HC6 , &H82 , &HC6 , &H7C , &H38 , &H00  '  &H4f
Data &H82 , &HFE , &HFE , &H92 , &H90 , &HF0 , &H60 , &H00  '  &H50
Data &H78 , &HFC , &H84 , &H8E , &HFE , &H7A , &H00 , &H00  '  &H51
Data &H82 , &HFE , &HFE , &H98 , &H9C , &HF6 , &H62 , &H00  '  &H52
Data &H64 , &HE6 , &HB2 , &H9A , &HDE , &H4C , &H00 , &H00  '  &H53
Data &HC0 , &H82 , &HFE , &HFE , &H82 , &HC0 , &H00 , &H00  '  &H54
Data &HFE , &HFE , &H02 , &H02 , &HFE , &HFE , &H00 , &H00  '  &H55
Data &HF8 , &HFC , &H06 , &H06 , &HFC , &HF8 , &H00 , &H00  '  &H56
Data &HFE , &HFE , &H0C , &H18 , &H0C , &HFE , &HFE , &H00  '  &H57
Data &HC6 , &HEE , &H38 , &H10 , &H38 , &HEE , &HC6 , &H00  '  &H58
Data &HE0 , &HF2 , &H1E , &H1E , &HF2 , &HE0 , &H00 , &H00  '  &H59
Data &HE6 , &HCE , &H9A , &HB2 , &HE2 , &HC6 , &H8E , &H00  '  &H5a
Data &H00 , &HFE , &HFE , &H82 , &H82 , &H00 , &H00 , &H00  '  &H5b
Data &H80 , &HC0 , &H60 , &H30 , &H18 , &H0C , &H06 , &H00  '  &H5c
Data &H00 , &H82 , &H82 , &HFE , &HFE , &H00 , &H00 , &H00  '  &H5d
Data &H10 , &H30 , &H60 , &HC0 , &H60 , &H30 , &H10 , &H00  '  &H5e
Data &H01 , &H01 , &H01 , &H01 , &H01 , &H01 , &H01 , &H01  '  &H5f
Data &H00 , &H00 , &HC0 , &HE0 , &H20 , &H00 , &H00 , &H00  '  &H60
Data &H04 , &H2E , &H2A , &H2A , &H3C , &H1E , &H02 , &H00  '  &H61
Data &H82 , &HFC , &HFE , &H22 , &H22 , &H3E , &H1C , &H00  '  &H62
Data &H1C , &H3E , &H22 , &H22 , &H36 , &H14 , &H00 , &H00  '  &H63
Data &H0C , &H1E , &H12 , &H92 , &HFC , &HFE , &H02 , &H00  '  &H64
Data &H1C , &H3E , &H2A , &H2A , &H3A , &H18 , &H00 , &H00  '  &H65
Data &H12 , &H7E , &HFE , &H92 , &HC0 , &H40 , &H00 , &H00  '  &H66
Data &H19 , &H3D , &H25 , &H25 , &H1F , &H3E , &H20 , &H00  '  &H67
Data &H82 , &HFE , &HFE , &H10 , &H20 , &H3E , &H1E , &H00  '  &H68
Data &H00 , &H22 , &HBE , &HBE , &H02 , &H00 , &H00 , &H00  '  &H69
Data &H02 , &H23 , &H21 , &HBF , &HBE , &H00 , &H00 , &H00  '  &H6a
Data &H82 , &HFE , &HFE , &H08 , &H1C , &H36 , &H22 , &H00  '  &H6b
Data &H00 , &H82 , &HFE , &HFE , &H02 , &H00 , &H00 , &H00  '  &H6c
Data &H3E , &H3E , &H30 , &H18 , &H30 , &H3E , &H1E , &H00  '  &H6d
Data &H3E , &H3E , &H20 , &H20 , &H3E , &H1E , &H00 , &H00  '  &H6e
Data &H1C , &H3E , &H22 , &H22 , &H3E , &H1C , &H00 , &H00  '  &H6f
Data &H21 , &H3F , &H1F , &H25 , &H24 , &H3C , &H18 , &H00  '  &H70
Data &H18 , &H3C , &H24 , &H25 , &H1F , &H3F , &H21 , &H00  '  &H71
Data &H22 , &H3E , &H1E , &H22 , &H38 , &H18 , &H00 , &H00  '  &H72
Data &H12 , &H3A , &H2A , &H2A , &H2E , &H24 , &H00 , &H00  '  &H73
Data &H00 , &H20 , &H7C , &HFE , &H22 , &H24 , &H00 , &H00  '  &H74
Data &H3C , &H3E , &H02 , &H02 , &H3C , &H3E , &H02 , &H00  '  &H75
Data &H38 , &H3C , &H06 , &H06 , &H3C , &H38 , &H00 , &H00  '  &H76
Data &H3C , &H3E , &H06 , &H0C , &H06 , &H3E , &H3C , &H00  '  &H77
Data &H22 , &H36 , &H1C , &H08 , &H1C , &H36 , &H22 , &H00  '  &H78
Data &H39 , &H3D , &H05 , &H05 , &H3F , &H3E , &H00 , &H00  '  &H79
Data &H32 , &H26 , &H2E , &H3A , &H32 , &H26 , &H00 , &H00  '  &H7a
Data &H10 , &H10 , &H7C , &HEE , &H82 , &H82 , &H00 , &H00  '  &H7b
Data &H00 , &H00 , &H00 , &HEE , &HEE , &H00 , &H00 , &H00  '  &H7c
Data &H82 , &H82 , &HEE , &H7C , &H10 , &H10 , &H00 , &H00  '  &H7d
Data &H40 , &HC0 , &H80 , &HC0 , &H40 , &HC0 , &H80 , &H00  '  &H7e
Data &H1E , &H3E , &H62 , &HC2 , &H62 , &H3E , &H1E , &H00  '  &H7f
Data &H78 , &HFD , &H87 , &H86 , &HCC , &H48 , &H00 , &H00  '  &H80
Data &H5C , &H5E , &H02 , &H02 , &H5E , &H5E , &H02 , &H00  '  &H81
Data &H1C , &H3E , &H6A , &HEA , &HBA , &H18 , &H00 , &H00  '  &H82
Data &H40 , &HC4 , &HAE , &HAA , &HAA , &HBE , &HDE , &H42  '  &H83
Data &H84 , &HAE , &H2A , &H2A , &HBE , &H9E , &H02 , &H00  '  &H84
Data &H04 , &HAE , &HEA , &H6A , &H3E , &H1E , &H02 , &H00  '  &H85
Data &H00 , &H44 , &HEE , &HAA , &HAA , &HFE , &H5E , &H02  '  &H86
Data &H38 , &H7D , &H47 , &H46 , &H6C , &H28 , &H00 , &H00  '  &H87
Data &H40 , &HDC , &HBE , &HAA , &HAA , &HBA , &HD8 , &H40  '  &H88
Data &H9C , &HBE , &H2A , &H2A , &HBA , &H98 , &H00 , &H00  '  &H89
Data &H1C , &HBE , &HEA , &H6A , &H3A , &H18 , &H00 , &H00  '  &H8a
Data &H80 , &HA2 , &H3E , &H3E , &H82 , &H80 , &H00 , &H00  '  &H8b
Data &H40 , &HC0 , &HA2 , &HBE , &HBE , &HC2 , &H40 , &H00  '  &H8c
Data &H00 , &HA2 , &HFE , &H7E , &H02 , &H00 , &H00 , &H00  '  &H8d
Data &H9E , &HBE , &H64 , &H64 , &HBE , &H9E , &H00 , &H00  '  &H8e
Data &H0E , &H5E , &HB4 , &HB4 , &H5E , &H0E , &H00 , &H00  '  &H8f
Data &H22 , &H3E , &H7E , &HEA , &HAA , &H22 , &H00 , &H00  '  &H90
Data &H04 , &H2E , &H2A , &H2A , &H3E , &H3E , &H2A , &H2A  '  &H91
Data &H3E , &H7E , &HD0 , &H90 , &HFE , &HFE , &H92 , &H00  '  &H92
Data &H4C , &HDE , &H92 , &H92 , &HDE , &H4C , &H00 , &H00  '  &H93
Data &H4C , &H5E , &H12 , &H12 , &H5E , &H4C , &H00 , &H00  '  &H94
Data &H0C , &H9E , &HD2 , &H52 , &H1E , &H0C , &H00 , &H00  '  &H95
Data &H5C , &HDE , &H82 , &H82 , &HDE , &H5E , &H02 , &H00  '  &H96
Data &H1C , &H9E , &HC2 , &H42 , &H1E , &H1E , &H02 , &H00  '  &H97
Data &H5D , &H5D , &H05 , &H05 , &H5F , &H5E , &H00 , &H00  '  &H98
Data &H9C , &HBE , &H22 , &H22 , &H22 , &HBE , &H9C , &H00  '  &H99
Data &HBC , &HBE , &H02 , &H02 , &HBE , &HBC , &H00 , &H00  '  &H9a
Data &H1C , &H3E , &H26 , &H2A , &H32 , &H3E , &H1C , &H00  '  &H9b
Data &H16 , &H7E , &HFE , &H92 , &HC2 , &H66 , &H04 , &H00  '  &H9c
Data &H3A , &H7C , &HCE , &H92 , &HE6 , &H7C , &HB8 , &H00  '  &H9d
Data &H22 , &H36 , &H1C , &H1C , &H36 , &H22 , &H00 , &H00  '  &H9e
Data &H02 , &H13 , &H11 , &H7F , &HFE , &H90 , &HD0 , &H40  '  &H9f
Data &H04 , &H2E , &H6A , &HEA , &HBE , &H1E , &H02 , &H00  '  &Ha0
Data &H00 , &H22 , &H7E , &HFE , &H82 , &H00 , &H00 , &H00  '  &Ha1
Data &H0C , &H1E , &H12 , &H52 , &HDE , &H8C , &H00 , &H00  '  &Ha2
Data &H1C , &H1E , &H02 , &H42 , &HDE , &H9E , &H02 , &H00  '  &Ha3
Data &H5E , &HDE , &H90 , &HD0 , &H5E , &HCE , &H80 , &H00  '  &Ha4
Data &H5E , &HDE , &H98 , &HCC , &H5E , &HDE , &H80 , &H00  '  &Ha5
Data &H00 , &H64 , &HF4 , &H94 , &HF4 , &HF4 , &H14 , &H00  '  &Ha6
Data &H00 , &H64 , &HF4 , &H94 , &H94 , &HF4 , &H64 , &H00  '  &Ha7
Data &H0C , &H1E , &HB2 , &HA2 , &H06 , &H04 , &H00 , &H00  '  &Ha8
Data &H38 , &H44 , &HBE , &HD2 , &HDA , &HA6 , &H44 , &H38  '  &Ha9
Data &H10 , &H10 , &H10 , &H10 , &H1C , &H1C , &H00 , &H00  '  &Haa
Data &H86 , &HFC , &HF8 , &H33 , &H77 , &HD5 , &H9D , &H09  '  &Hab
Data &H86 , &HFC , &HF8 , &H32 , &H66 , &HCE , &H9B , &H1F  '  &Hac
Data &H00 , &H00 , &H06 , &H5F , &H5F , &H06 , &H00 , &H00  '  &Had
Data &H10 , &H38 , &H6C , &H44 , &H10 , &H38 , &H6C , &H44  '  &Hae
Data &H44 , &H6C , &H38 , &H10 , &H44 , &H6C , &H38 , &H10  '  &Haf
Data &H55 , &H00 , &HAA , &H00 , &H55 , &H00 , &HAA , &H00  '  &Hb0
Data &H55 , &HAA , &H55 , &HAA , &H55 , &HAA , &H55 , &HAA  '  &Hb1
Data &HAA , &HFF , &H55 , &HFF , &HAA , &HFF , &H55 , &HFF  '  &Hb2
Data &H00 , &H00 , &H00 , &HFF , &HFF , &H00 , &H00 , &H00  '  &Hb3
Data &H08 , &H08 , &H08 , &HFF , &HFF , &H00 , &H00 , &H00  '  &Hb4
Data &H0E , &H1E , &H34 , &H74 , &HDE , &H8E , &H00 , &H00  '  &Hb5
Data &H4E , &H9E , &HB4 , &HB4 , &H9E , &H4E , &H00 , &H00  '  &Hb6
Data &H8E , &HDE , &H74 , &H34 , &H1E , &H0E , &H00 , &H00  '  &Hb7
Data &H38 , &H44 , &HBA , &HAA , &HAA , &H82 , &H44 , &H38  '  &Hb8
Data &H28 , &H28 , &HEF , &HEF , &H00 , &HFF , &HFF , &H00  '  &Hb9
Data &H00 , &H00 , &HFF , &HFF , &H00 , &HFF , &HFF , &H00  '  &Hba
Data &H28 , &H28 , &H2F , &H2F , &H20 , &H3F , &H3F , &H00  '  &Hbb
Data &H28 , &H28 , &HE8 , &HE8 , &H08 , &HF8 , &HF8 , &H00  '  &Hbc
Data &H18 , &H3C , &H24 , &HE7 , &HE7 , &H24 , &H24 , &H00  '  &Hbd
Data &HD4 , &HF4 , &H3F , &H3F , &HF4 , &HD4 , &H00 , &H00  '  &Hbe
Data &H08 , &H08 , &H08 , &H0F , &H0F , &H00 , &H00 , &H00  '  &Hbf
Data &H00 , &H00 , &H00 , &HF8 , &HF8 , &H08 , &H08 , &H08  '  &Hc0
Data &H08 , &H08 , &H08 , &HF8 , &HF8 , &H08 , &H08 , &H08  '  &Hc1
Data &H08 , &H08 , &H08 , &H0F , &H0F , &H08 , &H08 , &H08  '  &Hc2
Data &H00 , &H00 , &H00 , &HFF , &HFF , &H08 , &H08 , &H08  '  &Hc3
Data &H08 , &H08 , &H08 , &H08 , &H08 , &H08 , &H08 , &H08  '  &Hc4
Data &H08 , &H08 , &H08 , &HFF , &HFF , &H08 , &H08 , &H08  '  &Hc5
Data &H44 , &HEE , &HAA , &HEA , &H7E , &HDE , &H82 , &H00  '  &Hc6
Data &H4E , &HDE , &HB4 , &HF4 , &H5E , &HCE , &H80 , &H00  '  &Hc7
Data &H00 , &H00 , &HF8 , &HF8 , &H08 , &HE8 , &HE8 , &H28  '  &Hc8
Data &H00 , &H00 , &H3F , &H3F , &H20 , &H2F , &H2F , &H28  '  &Hc9
Data &H28 , &H28 , &HE8 , &HE8 , &H08 , &HE8 , &HE8 , &H28  '  &Hca
Data &H28 , &H28 , &H2F , &H2F , &H20 , &H2F , &H2F , &H28  '  &Hcb
Data &H00 , &H00 , &HFF , &HFF , &H00 , &HEF , &HEF , &H28  '  &Hcc
Data &H28 , &H28 , &H28 , &H28 , &H28 , &H28 , &H28 , &H28  '  &Hcd
Data &H28 , &H28 , &HEF , &HEF , &H00 , &HEF , &HEF , &H28  '  &Hce
Data &H66 , &H3C , &H3C , &H24 , &H3C , &H3C , &H66 , &H00  '  &Hcf
Data &HA0 , &HE4 , &H4E , &HEA , &HBE , &H1C , &H00 , &H00  '  &Hd0
Data &H92 , &HFE , &HFE , &H92 , &HC6 , &HFE , &H38 , &H00  '  &Hd1
Data &H62 , &HBE , &HBE , &HAA , &HAA , &H62 , &H00 , &H00  '  &Hd2
Data &HA2 , &HBE , &H3E , &H2A , &HAA , &HA2 , &H00 , &H00  '  &Hd3
Data &H22 , &HBE , &HFE , &H6A , &H2A , &H22 , &H00 , &H00  '  &Hd4
Data &H50 , &H70 , &H10 , &H00 , &H00 , &H00 , &H00 , &H00  '  &Hd5
Data &H00 , &H22 , &H7E , &HFE , &HA2 , &H00 , &H00 , &H00  '  &Hd6
Data &H40 , &HA2 , &HBE , &HBE , &HA2 , &H40 , &H00 , &H00  '  &Hd7
Data &H80 , &HA2 , &H3E , &H3E , &HA2 , &H80 , &H00 , &H00  '  &Hd8
Data &H08 , &H08 , &H08 , &HF8 , &HF8 , &H00 , &H00 , &H00  '  &Hd9
Data &H00 , &H00 , &H00 , &H0F , &H0F , &H08 , &H08 , &H08  '  &Hda
Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF  '  &Hdb
Data &H0F , &H0F , &H0F , &H0F , &H0F , &H0F , &H0F , &H0F  '  &Hdc
Data &H00 , &H00 , &H00 , &HEE , &HEE , &H00 , &H00 , &H00  '  &Hdd
Data &H00 , &HA2 , &HFE , &H7E , &H22 , &H00 , &H00 , &H00  '  &Hde
Data &HF0 , &HF0 , &HF0 , &HF0 , &HF0 , &HF0 , &HF0 , &HF0  '  &Hdf
Data &H1C , &H3E , &H62 , &HE2 , &HA2 , &H3E , &H1C , &H00  '  &He0
Data &H3F , &H7F , &H54 , &H54 , &H7C , &H28 , &H00 , &H00  '  &He1
Data &H5C , &HBE , &HA2 , &HA2 , &HA2 , &HBE , &H5C , &H00  '  &He2
Data &H1C , &H3E , &HA2 , &HE2 , &H62 , &H3E , &H1C , &H00  '  &He3
Data &H4C , &HDE , &H92 , &HD2 , &H5E , &HCC , &H80 , &H00  '  &He4
Data &H5C , &HFE , &HA2 , &HE2 , &H62 , &HFE , &H9C , &H00  '  &He5
Data &H01 , &H7F , &H7E , &H04 , &H04 , &H7C , &H78 , &H00  '  &He6
Data &H42 , &H7E , &H7E , &H2A , &H38 , &H10 , &H00 , &H00  '  &He7
Data &H82 , &HFE , &HFE , &HAA , &H28 , &H38 , &H10 , &H00  '  &He8
Data &H3C , &H3E , &H42 , &HC2 , &HBE , &H3C , &H00 , &H00  '  &He9
Data &H5C , &H9E , &H82 , &H82 , &H9E , &H5C , &H00 , &H00  '  &Hea
Data &H3C , &HBE , &HC2 , &H42 , &H3E , &H3C , &H00 , &H00  '  &Heb
Data &H1D , &H1D , &H45 , &HC5 , &H9F , &H1E , &H00 , &H00  '  &Hec
Data &H30 , &H3A , &H4E , &HCE , &HBA , &H30 , &H00 , &H00  '  &Hed
Data &H40 , &H40 , &H40 , &H40 , &H40 , &H40 , &H00 , &H00  '  &Hee
Data &H00 , &H00 , &H40 , &HC0 , &H80 , &H00 , &H00 , &H00  '  &Hef
Data &H08 , &H08 , &H08 , &H08 , &H08 , &H08 , &H00 , &H00  '  &Hf0
Data &H22 , &H22 , &HFA , &HFA , &H22 , &H22 , &H00 , &H00  '  &Hf1
Data &H14 , &H14 , &H14 , &H14 , &H14 , &H14 , &H00 , &H00  '  &Hf2
Data &H8E , &HAC , &HF8 , &H32 , &H66 , &HCE , &H9B , &H1F  '  &Hf3
Data &H60 , &HF0 , &H90 , &HFE , &HFE , &H80 , &HFE , &HFE  '  &Hf4
Data &H5B , &HFD , &HA5 , &HA5 , &HBF , &H9A , &HC0 , &H40  '  &Hf5
Data &H10 , &H10 , &HD6 , &HD6 , &H10 , &H10 , &H00 , &H00  '  &Hf6
Data &H00 , &H01 , &H03 , &H02 , &H00 , &H00 , &H00 , &H00  '  &Hf7
Data &H00 , &H60 , &HF0 , &H90 , &HF0 , &H60 , &H00 , &H00  '  &Hf8
Data &H40 , &H40 , &H00 , &H00 , &H40 , &H40 , &H00 , &H00  '  &Hf9
Data &H00 , &H00 , &H00 , &H08 , &H08 , &H00 , &H00 , &H00  '  &Hfa
Data &H00 , &H48 , &HC8 , &HF8 , &HF8 , &H08 , &H08 , &H00  '  &Hfb
Data &H00 , &H88 , &HA8 , &HA8 , &HF8 , &HF8 , &H50 , &H00  '  &Hfc
Data &H00 , &H98 , &HB8 , &HA8 , &HE8 , &H48 , &H00 , &H00  '  &Hfd
Data &H00 , &H00 , &H3C , &H3C , &H3C , &H3C , &H00 , &H00  '  &Hfe
Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00  ' &Hff