'###################################################
'umdrehungenzaehlen.bas
'Dieses Programm ist fr das Projekt RN-PropellerClock
'50 drehende Leds erzeugen ein Bild
'Boardbeschreibung Roboternetz.de oder robotikhardware.de

'
'Aufgabe:
'Nach dem Start wartet das Programm 20 Sekunden
'bis Motor hochgelaufen ist. Dann zhlt es 30 Sekunden die
'Umrundungen und errechnet die Drehzahl pro Min und Sek.
'Spbald die grne LED und gelbe LED aus ist, muss man
'nur nach PC mit der Teminalprogramm anschlieen.
'Dort wird die gemessene Drehzahl endlos ausgegeben

'
'Autor: Frank
'Weitere Beispiele und Beschreibung der Hardware
'unter http://www.Roboternetz.de bzw. robotikhardware.de
'###################################################


$programmer = 12                                            'MCS USB  (Zeile weglassen wenn anderer Programmer)
$regfile = "m644def.dat"
$crystal = 20000000                                         'Quarzfrequenz
$baud = 9600
$hwstack = 80
$framesize = 80
$swstack = 80

$lib "I2C_TWI.LBX"
Config Twi = 1100000                                        ' wanted clock frequency
Config Scl = Portc.0                                        'Ports fuer IIC-Bus
Config Sda = Portc.1



Const An = 0
Const Aus = 1









Config Int1 = Falling                                       'Rundenstart duch Hallsensor ermitteln


Config Pind.4 = Output
Led49_gruen Alias Portd.4

Config Pind.7 = Output
Led50_gelb Alias Portd.7

Config Pind.5 = Output
Irled Alias Portd.5

Config Pind.3 = Input
Hallsensor Alias Pind.3

Config Pind.6 = Input
Spannung Alias Pind.6



Dim Timervorgabe As Word


Dim Dreht As Byte
Dim Umin As Word
Dim Ergebnis As Word
Dim Ergebnis2 As Word
Dim Sekunden As Byte


Config Timer1 = Timer , Prescale = 1024                     'Sekundentakt
Timervorgabe = 46005                                        '1 Sekunde

Disable Timer1
Disable Int1
On Timer1 Zeitabgelaufen
On Int1 Rundenstart

Sekunden = 0
Dreht = 0
Umin = 0
Ergebnis = 0
Led50_gelb = An
Led49_gruen = Aus
Wait 20
Enable Int1
Enable Interrupts

Do
  If Ergebnis > 0 Then
       Print "Umdrehungen pro Minute:" ; Ergebnis
       Ergebnis2 = Ergebnis / 60
       Wait 1
       Print "Umdrehungen pro Sekunde:" ; ergebnis2
       Wait 1
       Print
       Print
       Wait 1
  End If

Loop



' *** Interrupt Routine wird aktiviert wenn Hallsensor Magnet erkennt
' *** also wenn Runde startet
Rundenstart:
    If Dreht = 0 Then
      Dreht = 1
      Timer1 = Timervorgabe
      Enable Timer1
      Toggle Led49_gruen
    Else
       Incr Umin
       Toggle Led49_gruen
    End If
Return






Zeitabgelaufen:
  Timer1 = Timervorgabe
  If Umin > 0 Then
    Incr Sekunden
    If Sekunden >= 30 Then
      Disable Int1
      Disable Timer1
      Ergebnis = Umin * 2
      Led50_gelb = Aus
      Led49_gruen = Aus
    End If
  End If
Return

