'###################################################
'rnmega8plusfunkmodulbefehl.bas  (c) 2006
'fr
'RoboterNetz Board RN-MEGA8PLUS nur fr Version 1.5 der Platine
'Das neue preiswerte Entwicklungsboard zum experimentieren
'
'Aufgabe:
' Dieses Testprogramm testet das Funkmodul
' Es werden einige Grundeinstellungen vorgenommen (Konfiguration)

' Als LCD wird hier ein EADIP LCD mit Adapter RN-LCDAdapter genutzt
' es knnen natrlich auch andere angepasst werden
' Ohne LCD geht es auch, jedoch sieht man dann Diagnose nicht

' Achtung: Bei eingestecktem Funkmodul muss IC1 (MAX232)
'          aus Fassung entfernt werden

'Autor: Frank
'Weitere Beispiele und Beschreibung der Hardware
'unter http://www.Roboternetz.de oder robotikhardware.de
'Eigene Programmbeispiele sind im Roboternetz gerne willkommen!
'##############################################################



$regfile = "m8def.dat"
$hwstack = 82
$framesize = 68
$swstack = 68


$crystal = 16000000                                         'Quarzfrequenz
'$crystal = 7372800                                          'Quarzfrequenz
$baud = 19200
Config Scl = Portc.5                                        'Ports fuer IIC-Bus
Config Sda = Portc.4

Declare Sub Rn_funkmodulversion();
Declare Function Rn_sendefunkbefehl(byval Funkbefehl As String) As Byte
Declare Function Rn_empfange_funkstring(dat As String) As Byte


Dim I As Word
Dim S As String * 90
Dim Rueck As Byte



' Falls ein LCD Display angeschlossen ist
Dim ___lcdno As Bit
Config Lcdpin = Pin , E = Portc.3 , E2 = Portd.7 , Rs = Portc.2 , Db4 = Portd.2 , Db5 = Portd.3 , Db6 = Portd.4 , Db7 = Portd.5
Config Lcd = 20 * 4a , Chipset = Ks077
Config Lcdbus = 4
Config Pind.6 = Output                                      'RW=0
Portd.6 = 0
Config Pind.7 = Output
Portd.7 = 1                                                 'LCD Licht ein

Initlcd
Cursor Off
Cls
Wait 1
Sound Portb.0 , 400 , 450                                   'BEEP
Sound Portb.0 , 400 , 250                                   'BEEP
Sound Portb.0 , 400 , 450                                   'BEEP


'RS232 Buffern
Config Serialin = Buffered , Size = 120
Config Serialout = Buffered , Size = 120
Enable Interrupts


Print
Print "**** RN-MEGA8PLUS V 1.5 *****"
Print "Das neue Entwicklungsboard mit Funkmodul Steckplatz von www.robotikhardware.de"
Lcd "RN-MEGA8PLUS V 1.5"
Locate 2 , 1
Lcd "Funkmodul testen"


   I = 0

   For I = 15 To 0 Step -1
     Locate 3 , 1
     Lcd "Countdown:" ; I ; "  "
     Wait 1
   Next I




     Wait 1
     Cls
     Locate 3 , 1
     Lcd "Firmware abrufen"
     Rueck = Rn_sendefunkbefehl( "ER_CMD#T3")
     If Rueck <> 0 Then
        Locate 4 , 1
        Lcd "ERROR"
     End If
     Rueck = Rn_empfange_funkstring(s)
     Locate 4 , 1
     Lcd "V " ; S

     Wait 3

'     Wait 1
'     Print #2 , "Schaltet auf 9600 Baud"
'     Rueck = Rn_sendefunkbefehl( "ER_CMD#U3")
'     Baud = 9600

     Wait 2
     Cls
     Locate 3 , 1
     Lcd "19200 Baud einstellen"
     Rueck = Rn_sendefunkbefehl( "ER_CMD#U4")
     Baud = 19200


'     Wait 1
'     Print #2 , "Schaltet auf niedrigste Sendeleistung  1 mW"
'     Rueck = Rn_sendefunkbefehl( "ER_CMD#P0")

     Wait 2
     Cls
     Locate 3 , 1
     Lcd "Sendeleisteung 10mW"
     Rueck = Rn_sendefunkbefehl( "ER_CMD#P9")
     If Rueck <> 0 Then
        Locate 4 , 1
        Lcd "ERROR"
     End If



     Wait 2
     Cls
     Locate 3 , 1
     Lcd "Kanal 0 einstellen"
     Rueck = Rn_sendefunkbefehl( "ER_CMD#C0")
     If Rueck <> 0 Then
        Locate 4 , 1
        Lcd "ERROR"
     End If


     Wait 2
     Cls
     Locate 3 , 1
     Lcd "Sende in Schleife"
     Wait 3


     Do
         Locate 4 , 1
         Lcd "Sende HALLO:" ; I ; "    "
         Print "Hallo:" ; I
         I = I + 1
         Wait 1
     Loop
End








'Sendet EasyRadio Befehl und prft ob korrekt empfangen
'Rckgabe: 0=Erfolgreich 1=Fehler
Function Rn_sendefunkbefehl(byval Funkbefehl As String) As Byte
Local Sech As String * 20
Local Z As Byte

    Print Funkbefehl;
    Waitms 20
    Sech = ""
    Do                                                      'Auf Echo warten
      Z = Inkey()
      Sech = Sech + Chr(z)
    Loop Until Z = 0

    If Left(sech , 9) = Funkbefehl Then
      Print "ACK";
      Rn_sendefunkbefehl = 0
    Else
      Rn_sendefunkbefehl = 1
    End If
End Function


'Empfngt Datenstring (Holt alles aus dem Eingabebuffer)
'Rckgabe: 0=Erfolgreich 1=Fehler
Function Rn_empfange_funkstring(dat As String) As Byte
Local Z As Byte

    Waitms 20
    Dat = ""
    Do                                                      'Auf Echo warten
      Z = Inkey()
      If Z <> 0 Then Dat = Dat + Chr(z)
    Loop Until Z = 0
    Rn_empfange_funkstring = 0
End Function