'###################################################
'rnmega8plustest.bas  (c) 2006
'fr
'RoboterNetz Board RN-MEGA8PLUS nur fr Version 1.5 der Platine
'Das neue preiswerte Entwicklungsboard zum experimentieren
'
'Aufgabe:
' Dieses Testprogramm testet gleich mehrere Eigenschaften auf dem Board
' Den verschiedenen Tasten sind bestimmte Funktionen zugeordnet
' Taste 1: Zeigt Batteriespannung ber RS232 und LCD  an
' Taste 2: Gibt per Zufall einen Lottozahlentip ab - 6 aus 49
' Taste 3: Einige male Lauflicht ber ein Balken-LEDs (2 Ports  bleiben an, da dies rs232 Ports sind)
'          Bei einer LED kommt es zu leichtem Knacksen, da der Piepser diesen Port ebenfalls nutzt

' Taste 4: Ein einfaches Sirenengerusch
''Taste 5: Zeigt Copyriht auf LCD Display

' Jumper EXREF (Externe Referenzspannung) darf niucht gesteckt sein, da dieses
' Demo die Referenzspannung per Software auf 5V legt
' Bei vernderter Referenzspannung muss Tastenabfrage angepat werden

' Als LCD wird hier ein EADIP LCD mit Adapter RN-LCDAdapter genutzt
' es knnen natrlich auch andere angepasst werden

' Sehr gut kann man aus dem Demo auch entnehmen wie Sound ausgegeben wird,
' wie Tasten abgefragt werden und wie Subroutinen und Funktionen angelegt werden

'Autor: Frank
'Weitere Beispiele und Beschreibung der Hardware
'unter http://www.Roboternetz.de oder robotikhardware.de
'Eigene Programmbeispiele sind im Roboternetz gerne willkommen!
'##############################################################


Declare Sub Batteriespannung()
Declare Sub Lauflicht()
Declare Function Tastenabfrage() As Byte
Declare Sub Textauflcdausgeben()
Declare Sub Lottozahlen()
Declare Sub Sirene()

$regfile = "m8def.dat"
$hwstack = 82
$framesize = 68
$swstack = 68


$crystal = 16000000                                         'Quarzfrequenz
'$crystal = 7372800                                          'Quarzfrequenz
$baud = 9600
Config Scl = Portc.5                                        'Ports fuer IIC-Bus
Config Sda = Portc.4



Config Adc = Single , Prescaler = Auto , Reference = Avcc
                          'Fr Tastenabfrage und Spannungsmessung
Config Pinc.0 = Input                                       'Fr Tastenabfrage
Portc.0 = 1                                                 'Pullup Widerstand ein

Start Adc
Const Ref = 5 / 1023                                        'Fr Batteriespannungsberechnung
         'Bei einer anderen Referenzspannung muss die 2.5 durch entsprechend ersetzt werden
         'Die Referenzspannung wird durch den Jumper JPREF bzw. Spindeltrimmer  festgelegt

Dim I As Integer
Dim N As Integer
Dim Ton As Integer
Dim Ws As Word                                              'Wird fr Messung bei Tastenabfrage verwendet
Dim Adc_ohne_taste As Word

Dim Taste As Byte
Dim Volt As Single


' Falls ein LCD Display angeschlossen ist
Dim ___lcdno As Bit
Config Lcdpin = Pin , E = Portc.3 , E2 = Portd.7 , Rs = Portc.2 , Db4 = Portd.2 , Db5 = Portd.3 , Db6 = Portd.4 , Db7 = Portd.5
Config Lcd = 20 * 4a , Chipset = Ks077
Config Lcdbus = 4
Config Pind.6 = Output                                      'RW=0
Portd.6 = 0
Config Pind.7 = Output
Portd.7 = 1                                                 'LCD Licht ein

Initlcd
Cursor Off
Cls


Wait 1

I2cinit                                                     'Falls I2C benutzt wird

I = 0
Sound Portb.0 , 400 , 450                                   'BEEP
Sound Portb.0 , 400 , 250                                   'BEEP
Sound Portb.0 , 400 , 450                                   'BEEP


Print

Call Textauflcdausgeben


Adc_ohne_taste = Getadc(0)                                  'Messe Spannung wenn keine Taste gedrckt ist
Adc_ohne_taste = Adc_ohne_taste - 2                         'fr Toleranz abziehen


Do
   Taste = Tastenabfrage()
   If Taste <> 0 Then
      Select Case Taste
         Case 1
             Call Batteriespannung                          'Taste 1 Zeigt Bateriespannung ber RS232 an
          Case 2
             Call Lottozahlen                               'Gibt Lottozahlen-Tip (ohne Gewhr) ber rs232 und lcd
                                                             'Bei Gewinn bitte mit Autor Frank teilen :-)
         Case 3
            Call Lauflicht                                  'Einige male Lauflicht ber Balken LEDs anzeigen
         Case 4
            Call Sirene
         Case 5
            Call Textauflcdausgeben
      End Select

      Sound Portb.0 , 400 , 500                             'BEEP
   End If
   Waitms 100
Loop

End


'Diese Unterfunktion fragt die Tastatur am analogen Port ab
Function Tastenabfrage() As Byte
   Tastenabfrage = 0
   Ton = 600
   Ws = Getadc(0)
'   Print "ws=" ; Ws  'Auskommentieren wenn man Tastenabfrage an andere Referenzspannung anpassen mchte
   If Ws < Adc_ohne_taste Then
      Select Case Ws
         Case 400 To 440
            Tastenabfrage = 1
            Ton = 550
         Case 330 To 370
            Tastenabfrage = 2
            Ton = 500
         Case 260 To 300
            Tastenabfrage = 3
            Ton = 450
         Case 180 To 230
            Tastenabfrage = 4
            Ton = 400
         Case 100 To 130
            Tastenabfrage = 5
            Ton = 350
         Case Else
            Print "Bitte Tastenabfrage an Messert ws=" ; Ws ; " anpassen!"
      End Select
      Sound Portb.0 , 400 , Ton                             'BEEP
   End If

End Function




'Diese Unterfunktion zeigt Bateriespannung an
Sub Batteriespannung()
Local W As Word
   Start Adc
   W = Getadc(1)
   Volt = W * Ref
   Volt = Volt * 5.3137                                     'Spannungsteiler (R9+R10)/R9
   Print "Die aktuelle Spannung betrgt: " ; Volt ; " Volt"
   Print "Rev: " ; Ref ; " W=" ; W

   Cls
   Locate 1 , 1
   Lcd "Spannung:" ; Fusing(volt , "#.##") ; " Volt"
End Sub


'Dies Funktion gibt auf einem angeschlossenen LCD-Display (2x27 Zeichen)
'eine Copyright Meldung aus
Sub Textauflcdausgeben()
 Cls
 Home
 Locate 1 , 1
 Lcd "Experimentierboard"
 Locate 2 , 1
 Lcd "RN-MEGA8PLUS V1.5"
 Locate 3 , 1
 Lcd "Roboternetz Standard"
 Locate 4 , 1
 Lcd "robotikhardware.de"

 'Fuer RS232
 Print "**** RN-MEGA8PLUS V 1.5 *****"
 Print "Das neue Entwicklungsboard mit Funkmodul Steckplatz von www.robotikhardware.de"
End Sub

'Einige male Lauflicht ber Balkenanzeige laufen lassen
Sub Lauflicht()


   Config Portd = Output
   Config Pinb.0 = Output
   Config Pinb.1 = Output

   Portd = 255
   Portb.0 = 1
   Portb.1 = 1
   For N = 1 To 10
      For I = 0 To 9
         Select Case I
            Case 0 To 7 :
               Portd.i = 0
               Waitms 150
               Portd.i = 1
            Case 8:
               Portb.0 = 0
               Waitms 150
               Portb.0 = 1
            Case 9:
               Portb.1 = 0
               Waitms 150
               Portb.1 = 1


         End Select
      Next I
   Next N
   Config Portd = Input
   Config Pinb.0 = Input
   Config Pinb.1 = Input
   !Call 0                                                  'Fhrt RESET aus
End Sub


Sub Lottozahlen()
  Print "Lotozahlen: ";
  Cls
  Home
   Lcd "Lottozahlentip-ohne Gewaehr):" "
   Locate 2 , 1
    For I = 1 To 6
     N = Rnd(48)
     N = N + 1
     Print " " ; N ;
     Lcd " " ; N;
   Next I
   Print
End Sub


Sub Sirene()
    For N = 1 To 5
       For I = 500 To 900
         Sound Portb.0 , 5 , I
       Next I
       For I = 900 To 500 Step -1
         Sound Portb.0 , 5 , I
       Next I
    Next N
End Sub