'###################################################
'SRF02_rncontrol_i2c_beispiel2.bas
'fr
'RoboterNetz Board RN-CONTROL (ab Version 1.1)
'und das SRF02 Ultraschallmodul fr Entfernungsmessung
'Datenblatt zu SRF02:
'http://www.roboternetz.de/phpBB2/dload.php?action=file&file_id=357
'Anschlussbeschreibung:
'http://www.roboternetz.de/wissen/index.php/Sensorarten

'Aufgabe:
' Gibt die Firmware-Version vom SRF02 aus und
' anschlieend in einer Endlosschleife die
' Entfernung von Objekten in Zentimetern
' Die Entfernung wird 1 mal pro Sekunde ber RS232
' ausgegeben
' Hier wird noch genau gescheckt ob ein Sensor die
' Messung schon beendet hat. Dadurch sind noch
' schnellere Messungen als nur 15 pro Sekunde mglich

'Autor: Frank  (Roboternetz)
'Weitere Beispiele und Beschreibung der Hardware
'unter http://www.Roboternetz.de oder robotikhardware.de
'#######################################################



Declare Function Srf02_firmware(byval Slaveid As Byte) As Byte
Declare Function Srf02_entfernung(byval Slaveid As Byte) As Integer


$regfile = "m32def.dat"
$framesize = 42
$swstack = 42
$hwstack = 42

$crystal = 16000000                                         'Quarzfrequenz
$baud = 9600

Config Scl = Portc.0                                        'Ports fuer IIC-Bus
Config Sda = Portc.1


Const Srf02_slaveid = &HE0                                  'Standard I2C Adresse von SRF02

Dim Entfernung As Integer
Dim V As Byte




   Wait 3                                                   'Warte 3 Sekunden
   I2cinit
   Print "SRF02 Testprogramm von robotikhardware.de"
   Print "SRF02 Ultraschall-Firmware Version:" ; Srf02_firmware(srf02_slaveid)


   V = 1
   Do
     Entfernung = Srf02_entfernung(srf02_slaveid)
     Print "Entfernung:" ; Entfernung ; "cm"
     Wait 1
   Loop


End



'------------- Hilfsfunktionen fr SRF02 ----------


Function Srf02_firmware(byval Slaveid As Byte) As Byte
Local Firmware As Byte
Local Slaveid_read As Byte

   slaveid_read = Slaveid + 1

   I2cstart
   I2cwbyte Slaveid
   I2cwbyte 0                                               'Leseregister festlegen
   I2cstop

   I2cstart
   I2cwbyte Slaveid_read
   I2crbyte Firmware , Nack
   I2cstop

   Srf02_firmware = Firmware
End Function



Function Srf02_entfernung(byval Slaveid As Byte) As Integer
Local Lob As Byte
Local Hib As Byte
Local Firmware As Byte
Local Temp As Byte
Local Slaveid_read As Byte

   slaveid_read = Slaveid + 1

   'Messvorgang in starten
   I2cstart
   I2cwbyte Slaveid
   I2cwbyte 0
   I2cwbyte 81                                              'in Zentimetern messen
   I2cstop


Warteaufmessung:
   Waitms 1
   Firmware = Srf02_firmware(slaveid)
   If Firmware = 255 Then Goto Warteaufmessung

   I2cstart
   I2cwbyte Slaveid
   I2cwbyte 2                                               'Leseregister festlegen
   I2cstop


   I2cstart
   I2cwbyte Slaveid_read
   I2crbyte Hib , Ack
   I2crbyte Lob , Nack
   I2cstop


   Srf02_entfernung = Makeint(lob , Hib)
End Function


