'###################################################
'SRF02_rncontrol_rs232_beispiel.bas
'fr
'RoboterNetz Board RN-CONTROL (ab Version 1.1)
'und das SRF02 Ultraschallmodul fr Entfernungsmessung
'Datenblatt zu SRF02:
'http://www.roboternetz.de/phpBB2/dload.php?action=file&file_id=357
'Anschlussbeschreibung:
'http://www.roboternetz.de/wissen/index.php/Sensorarten

'Aufgabe:
' Gibt die Firmware-Version vom SRF02 aus und
' anschlieend in einer Endlosschleife die
' Entfernung von Objekten in Zentimetern
' Die Entfernung wird 1 mal pro Sekunde ber RS232
' ausgegeben
' Dieses Beispiel nutzt den RS232 Mode vom SRF02
' Um die Ergebnisse auch gleichzeitig an PC
' bermitteln zu knnen, wird in dem Beispiel eine
' zweite RS232 Schnittstelle per Software eingerichtet.
' Dadurch kann der Sensor (oder auch mehrere) bequem
' an der Steckklemme angeschlossen werden

'Autor: Frank  (Roboternetz)
'Weitere Beispiele und Beschreibung der Hardware
'unter http://www.Roboternetz.de oder robotikhardware.de
'#######################################################



Declare Function Srf02_firmware(byval Slaveid As Byte) As Byte
Declare Function Srf02_entfernung(byval Slaveid As Byte) As Integer


$regfile = "m32def.dat"
$framesize = 42
$swstack = 42
$hwstack = 42

$crystal = 16000000                                         'Quarzfrequenz
$baud = 9600                                                'Normale Hardware RS232 (hier hngt PC dran)

Open "COMA.0:9600,8,N,2" For Output As #1                   'Port PA0 wird als TX definiert
Open "COMA.1:9600,8,N,2" For Input As #2                    'Port PA1 wird als RX definiert


Const Srf02_slaveid = 0                                     'Standard RS232 Slave ID von SRF02
Dim Entfernung As Integer


   Wait 3                                                   'Warte 3 Sekunden
   Print "SRF02 RS232 Testprogramm von robotikhardware.de"
   Print "SRF02 Ultraschall-Firmware Version:" ; Srf02_firmware(srf02_slaveid)
   Print "PA0 wird TX und PA1 wird als RX genutzt"


   V = 1
   Do
     Entfernung = Srf02_entfernung(srf02_slaveid)
     Print "Entfernung:" ; Entfernung ; "cm"
     Wait 1
   Loop
End



'------------- Hilfsfunktionen fr SRF02 ----------


Function Srf02_firmware(byval Slaveid As Byte) As Byte

   Print #1 , Chr(slaveid) ; Chr(93);
   Srf02_firmware = Waitkey(#2)
End Function



Function Srf02_entfernung(byval Slaveid As Byte) As Integer
Local Lob As Byte
Local Hib As Byte

   Print #1 , Chr(slaveid) ; Chr(84);                       'Messvorgang in cm starten
   Inputbin #2 , Hib , Lob                                  'Warte auf Ergebnis
   Srf02_entfernung = Makeint(lob , Hib)
End Function
