'###################################################
'Schrittmotoransteuerung mit RN-Control und
'Ansteuerungsboard RN-Stepp297
'RN-Stepp297 ist die bekannt Standardschaltung
'mit L297 und L298 (Bausatz)
'rn_stepp297_beispiel2.bas
'
' Achtung:
' Diese Demo ist mit Bascom Compiler 1.11.8.4 getestet
' Getestet mit RN-Schrittmotor Firmware V 1.1
'
' RN-Stepp97 wird wie folgt angeschlossen
' Enable auf PA0 / Richtung auf PA1 / Takt auf PA2
'
'Aufgabe:
' Dieses Testprogramm zeigt wie man RN-Stepp297
' ber Takt- und Richtungsleitung mit hoher
' Taktfrequenz ansteuert. Nicht alle Schrittmotoren
' machen diesen Geschwindigkeit mit!

' Den verschiedenen Tasten sind bestimmte Funktionen zugeordnet
' Taste 1: Schrittmotor genau mit 500 Schritten pro Sekunde drehen
' Taste 2: Schrittmotor genau mit 1000 Schritten pro Sekunde drehen
' Taste 3: Schrittmotor genau mit 1500 Schritten pro Sekunde drehen
' Taste 4: Schrittmotor genau mit 2000 Schritten pro Sekunde drehen
''Taste 5: Schrittmotor genau mit 3000 Schritten pro Sekunde drehen
'
'Autor: Frank
'Weitere Beispiele und Beschreibung der Hardware
'in der Anleitung zu RN-Schrittmotor
'Anleitung findet man unter http://www.Roboternetz.de im Download Bereich
'oder www.robotikhardware.de
'Weitere Beispiele sind im Roboternetz gerne willkommen!
'##############################################################

$programmer = 12                                            'MCS USB  (Zeile weglassen wenn anderer Programmer)




'  -------------- RN-Control bliche _____________________
Declare Function Tastenabfrage() As Byte

$regfile = "m32def.dat"
$framesize = 32
$swstack = 32
$hwstack = 64

$crystal = 16000000                                         'Quarzfrequenz
$baud = 9600
Config Scl = Portc.0                                        'Ports fuer IIC-Bus
Config Sda = Portc.1

Config Adc = Single , Prescaler = Auto                      'Fr Tastenabfrage und Spannungsmessung
Config Pina.7 = Input                                       'Fr Tastenabfrage
Porta.7 = 1                                                 'Pullup Widerstand ein
Dim Taste As Byte
Dim Ton As Integer

I2cinit
Start Adc
Sound Portd.7 , 400 , 450                                   'BEEP
Sound Portd.7 , 400 , 250                                   'BEEP
Sound Portd.7 , 400 , 450                                   'BEEP
Print
Print "**** RN-CONTROL  V1.4 *****"
Print "Demoprogramm um Zusatzboard RN-Stepp297 zu testen/demonstrieren"
Print
'  -------------- Ende RN-Control bliche _____________________


Config Pina.0 = Output
Stepper_enable Alias Porta.0

Config Pina.1 = Output
Stepper_richtung Alias Porta.1

Config Pina.2 = Output
Stepper_takt Alias Porta.2



Dim I As Integer
Dim Timervorgabe As Byte




Stepper_enable = 0                                          ' Erst mal aus
On Timer0 Timer_irq
Enable Timer0



Do
   Taste = Tastenabfrage()
   If Taste <> 0 Then

      Select Case Taste

         Case 1                                             'Schrittmotor genau mit 500 Schritten pro Sekunde drehen
           Stepper_enable = 1
           Config Timer0 = Timer , Prescale = 256
           Timervorgabe = 131
           Enable Interrupts

         Case 2                                             ''Schrittmotor genau mit 1000 Schritten pro Sekunde drehen
           Stepper_enable = 1
           Config Timer0 = Timer , Prescale = 64
           Timervorgabe = 6
           Enable Interrupts

         Case 3                                             ''Schrittmotor genau mit 1500 Schritten pro Sekunde drehen
           Stepper_enable = 1
           Config Timer0 = Timer , Prescale = 64
           Timervorgabe = 89
           Enable Interrupts

         Case 4                                             ''Schrittmotor genau mit 2000 Schritten pro Sekunde drehen
           Stepper_enable = 1
           Config Timer0 = Timer , Prescale = 64
           Timervorgabe = 131
           Enable Interrupts

         Case 5                                             ''Schrittmotor genau mit 3000 Schritten pro Sekunde drehen
           Stepper_enable = 1
           Config Timer0 = Timer , Prescale = 64
           Timervorgabe = 173
           Enable Interrupts


      End Select
      Sound Portd.7 , 400 , 500                             'BEEP
   End If

   Waitms 100
Loop

End




' Diese Unterfunktion fragt die Tastatur am analogen Port ab
' Sollte beim bettigen einer Taste kein Quittungston kommen, dann
' muss die die Tastenabfrage (Select Case Anweisung in Funktion )
' an ihr Board angepat werden. Widerstandstoleranzen sorgen in
' Einzelfllen manchmal dafr das die Werte etwas anders ausfallen
' Am besten dann den WS wert mit Print fr jede Taste ausgeben lassen

Function Tastenabfrage() As Byte
Local Ws As Word

   Tastenabfrage = 0
   Ton = 600
   Ws = Getadc(7)
'   Print "ws= " ; Ws
   If Ws < 1010 Then
      Select Case Ws
         Case 400 To 455
            Tastenabfrage = 1
            Ton = 550
         Case 335 To 380
            Tastenabfrage = 2
            Ton = 500
         Case 250 To 305
            Tastenabfrage = 3
            Ton = 450
         Case 180 To 220
            Tastenabfrage = 4
            Ton = 400
         Case 100 To 130
            Tastenabfrage = 5
            Ton = 350
      End Select
      Sound Portd.7 , 400 , Ton                             'BEEP
   End If

End Function



'Dies ist der Programmteil, der in dem von ihnen gewhlten
'Intervall aufgerufen wird
Timer_irq:
  Timer0 = Timervorgabe
  Stepper_takt = 0 : Waitus 1 : Stepper_takt = 1
  Return
