'###################################################
'
'rncontroltest.BAS
'fr
'RoboterNetz Board RN-CONTROL ab Version 1.1
'Das neue preiswerte Controllerboard zum experimentieren

' Achtung:
' Diese Demo ist mit Bascom Compiler 1.11.7.7 getestet

'
'Aufgabe:
' Dieses testprogramm testet gleich mehrere Eigenschaften auf dem Board
' Den verschiedenen Tasten sind bestimmte Funktionen zugeordnet
' Taste 1: Zeigt Batteriespannung ber RS232 an
' Taste 2: Angeschlossene Motoren beschleunigen und abbremsen
' Taste 3: Einige male Lauflicht ber LEDs anzeigen. Am I2C-Bus
'          darf in diesem Moment nichts angeschlossen sein
' Taste 4: Zeigt analoge Messwerte an allen Port A PINs ber RS232 an
''Taste 5: Zeigt digitalen I/O Zustand von PA0 bis PA5 an


' Sehr gut kann man aus dem Demo auch entnehmen wie Sound ausgegeben wird,
' wie Tasten abgefragt werden und wie Subroutinen und Funktionen angelegt werden

'Autor: Frank
'Weitere Beispiele und Beschreibung der Hardware
'unter http://www.Roboternetz.de oder http://www.mikrocontroller-elektronik.de/
'#######################################################

$programmer = 12                                            '1=LPT stk200  13=MCS Bootloader   12=USBISP 7=allavr/mk2
$PROG &HFF,&HFF,&HDB,&HFF' generated. Take care that the chip supports all fuse bytes.

Declare Sub Batteriespannung()
Declare Sub Motortest()
Declare Sub Lauflicht()
Declare Sub Showporta()
Declare Sub Showdigitalporta()
Declare Function Tastenabfrage() As Byte



'$PROG &HFF,&HFF,&HDB,&H00' Ohne bootloader

$regfile = "m32def.dat"
' bei Mega 16 $regfile = "m16def.dat"
$framesize = 32
$swstack = 32
$hwstack = 32


Dim I As Integer
Dim N As Integer
Dim Ton As Integer

$crystal = 16000000                                         'Quarzfrequenz
$baud = 9600

Config Adc = Single , Prescaler = Auto                      'Fr Tastenabfrage und Spannungsmessung

Config Pina.7 = Input                                       'Fr Tastenabfrage
Porta.7 = 1                                                 'Pullup Widerstand ein


Const Ref = 5 / 1023                                        'Fr Batteriespannungsberechnung

Dim Taste As Byte
Dim Volt As Single

' Fr Motorentest
'Ports fr linken Motor
Config Pinc.6 = Output                                      'Linker Motor Kanal 1
Config Pinc.7 = Output                                      'Linker Motor Kanal 2
Config Pind.4 = Output                                      'Linker Motor PWM
'Ports fr rechten Motor
Config Pinb.0 = Output                                      'Rechter Motor Kanal 1
Config Pinb.1 = Output                                      'Rechter Motor Kanal 2
Config Pind.5 = Output                                      'Rechter Motor PWM
'Config Timer1 = Pwm , Pwm = 10 , Compare_A_Pwm = Clear_up , Compare B Pwm = Clear Down
Config Timer1 = Pwm , Pwm = 10 , Compare_A_Pwm = Clear_up , Compare_B_Pwm = Clear_up
Pwm1a = 0
Pwm1b = 0
Tccr1b = Tccr1b Or &H02                                     'Prescaler = 8





I = 0
For I = 650 To 300 Step -2
  Sound Portd.7 , 5 , I
Next I

For I = 301 To 900
  Sound Portd.7 , 5 , I
Next I

Waitms 200

Sound Portd.7 , 400 , 450                                   'BEEP
Sound Portd.7 , 400 , 250                                   'BEEP
Sound Portd.7 , 400 , 450                                   'BEEP

Print
Print "**** RN-CONTROL 1.41 *****"
Print "Demoprogramm von http://www.mikrocontroller-elektronik.de/
Print "Das beliebte Experimentier- und Roboterboard"
Print "Weitere passende Zusatzboards bei http://www.mikrocontroller-elektronik.de/"
Print "lassen sich sehr bequem mit Bascom-Basic programmieren."
Print "Viele Tipps und Foren zu den RN-Boards gibt es unter"
Print "www.roboternetz.de und www.rn-wissen.de"


Do



   Taste = Tastenabfrage()
   If Taste <> 0 Then

      Select Case Taste
         Case 1
            Call Batteriespannung                           'Taste 1 Zeigt Bateriespannung ber RS232 an
         Case 2
            Call Motortest                                  'Taste 2 Motoren beschleunigen und abbremsen
         Case 3
            Call Lauflicht                                  'Einige male Lauflicht ber LEDs anzeigen. Am I2C-Port darf in diesem Moment nichts angeschlossen sein
         Case 4
            Call Showporta                                  'Zeigt Messwerte an allen Port A PINs
         Case 5
            Call Showdigitalporta                           'Zeigt digitalen I/O Zustand von PA0 bis PA5 an



      End Select
      Sound Portd.7 , 400 , 500                             'BEEP
   End If

   Waitms 100
Loop

End




'Diese Unterfunktion fragt die Tastatur am analogen Port ab
Function Tastenabfrage() As Byte
Local Ws As Word

   Tastenabfrage = 0
   Ton = 600
   Start Adc
   Ws = Getadc(7)
'  Print "Tastenabfrage anpassen!ADC Wert ws=" ; Ws
   If Ws < 500 Then
      Select Case Ws
         Case 370 To 450                                    'oder 400 x 450
            Tastenabfrage = 1
            Ton = 550
         Case 300 To 369
            Tastenabfrage = 2
            Ton = 500
         Case 230 To 299
            Tastenabfrage = 3
            Ton = 450
         Case 150 To 229
            Tastenabfrage = 4
            Ton = 400
         Case 80 To 149
            Tastenabfrage = 5
             Ton = 350
         Case Else
              Print "Tastenabfrage anpassen!ADC Wert ws=" ; Ws
      End Select
      Sound Portd.7 , 400 , Ton                             'BEEP

   End If


End Function



'Diese Unterfunktion zeigt Batteriespannung an
Sub Batteriespannung()
Local W As Word
   Start Adc
   W = Getadc(6)
   Volt = W * Ref
   Volt = Volt * 5.2941
   Print "Die aktuelle Spannung betrgt: " ; Volt ; " Volt"

End Sub


'Testet Motoren und Geschwindigkeitsreglung
Sub Motortest()

   Print "Motoren werden getestet ... ";

   Pwm1a=0
   Pwm1b =0
   print "Motoren ein"
   'Linker Motor ein
   Portc.6 = 1                                              'bestimmt Richtung
   Portc.7 = 0                                              'bestimmt Richtung
   Portd.4 = 1                                              'Linker Motor EIN

   'Rechter Motor ein
   Portb.0 = 1                                              'bestimmt Richtung rechter Motor
   Portb.1 = 0                                              'bestimmt Richtung rechter Motor
   Portd.5 = 1                                              'rechter Motor EIN
   wait 1

   print "Langsam beide hochfahren ..."
   I = 0
   Do
      Pwm1a = I
      Pwm1b = I
      Waitms 40
      I = I + 5
   Loop Until I > 1023

   print "Beide Vollgas erreicht"

   Wait 1
   print "beide langsam herunterfahren ..."
   i=1023
   Do
      Pwm1a = I
      Pwm1b = I
      Waitms 40
      I = I - 5
   Loop Until I < 1
   Pwm1a = 0                                                'Linker Motor aus
   Pwm1b = 0                                                'rechter Motor aus

   print "Beide gestoppt ..."
   wait 1
   print "nun gleiche in andere richtung ..."
  'andere Richtung

     'Linker Motor ein
   Portc.6 = 0                                              'bestimmt Richtung
   Portc.7 = 1                                              'bestimmt Richtung
   Portd.4 = 1                                              'Linker Motor EIN

   'Rechter Motor ein
   Portb.0 = 0                                              'bestimmt Richtung rechter Motor
   Portb.1 = 1                                              'bestimmt Richtung rechter Motor
   Portd.5 = 1                                              'rechter Motor EIN


   I = 0
   Do
      Pwm1a = I
      Pwm1b = I
      Waitms 40
      I = I + 5
   Loop Until I > 1023

   Wait 1
   i=1023
   Do
      Pwm1a = I
      Pwm1b = I
      Waitms 40
      I = I - 5
   Loop Until I < 1
   Pwm1a = 0                                                'Linker Motor aus
   Pwm1b = 0                                                'rechter Motor aus




   Print "Habe fertig ;-)"
End Sub


'Einige male Lauflicht ber LEDs anzeigen. Am I2C-Port darf in diesem Moment nichts angeschlossen sein
Sub Lauflicht()

   Print "Lauflicht - schau auf das Board. Achte darauf das DIP Schalter on sind"
   Config Portc = Output
   Portd = 0
   For N = 1 To 10
      For I = 0 To 7
         Portc.i = 0
         Waitms 100
         Portc.i = 1
      Next I
   Next N
   Config Portc = Input
End Sub


'Zeigt Die Analogen Messwerte An Port A An
Sub Showporta()
Local Ws As Word

   Config Porta = Input
   For I = 0 To 5                                           ' Alle internen Pullup Widerstnd ein,bis auf Batteriespannungsmessungsport
      Porta.i = 1
   Next I

   Print
   Print "Ermittelte Messwerte an Port A:"
   For I = 0 To 7                                           ' Alle Eingne inkl.messen
      Start Adc
      Ws = Getadc(i)
      Volt = Ws * Ref
      Print "Pin " ; I ; " ADC-Wert= " ; Ws ; " bei 5V REF waeren das " ; Volt ; " Volt"
   Next I
End Sub


'Zeigt den Zustand einiger freier I/O von Die Analogen Messwerte An Port A An
Sub Showdigitalporta()
Local Zustand As String * 6
   Config Porta = Input
   For I = 0 To 5                                           ' Alle internen Pullup Widerstnd ein,bis auf Batteriespannungsmessungsport
      Porta.i = 1
   Next I

   Print
   Print "Ermittelter I/O Zustand Port A:"
   For I = 0 To 5                                           ' Alle Eingne inkl.messen
      If Pina.i = 1 Then
         Zustand = "High"
      Else
         Zustand = "Low"
      End If
      Print "Pin " ; I ; " I/O Zustand= " ; Pina.i ; " " ; Zustand
   Next I
End Sub